@extends('layouts.master')



@section('title','Haberler - Haber Ekleme')



@section('content')


    <meta name="csrf-token" content="{{ csrf_token() }}">



<div class="main-content">

        <div class="page-content">

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                            <h4 class="mb-sm-0">Haber Ekleme</h4>



                            <div class="page-title-right">

                                <ol class="breadcrumb m-0">

                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Anasayfa</a></li>

                                    <li class="breadcrumb-item"><a href="{{ route('news.index') }}">Haberleri Görüntüle</a></li>

                                    <li class="breadcrumb-item active">Haber Ekle</li>

                                </ol>

                            </div>



                        </div>

                    </div>

                </div>



                <div class="row">

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-header align-items-center d-flex">

                                    <h4 class="card-title mb-0 flex-grow-1">Haber Bilgileri</h4>



                                </div><!-- end card header -->

                                <div class="card-body">

                                    <div class="live-preview">

                                        <form id="myForm" action="{{route('news.save')}}" method="POST"  enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                                        <div class="row gy-4">

                                          <div class="col-xxl-4 col-md-4">
                                                <label for="basiInput" class="form-label">Haber Adı</label>

                                                <div class="input-group">
                                                    <input type="text" id="title" required name="name" class="form-control" placeholder="Haber Adı" aria-label="Haber Adı">

                                                    <a href="javascript:void(0)" class="input-group-text" id="generate-title" title="Yapay Zeka'dan Başlık Üret" style="background: #fff; border-radius: 5px; ">
                                                        <i class="ri-robot-2-line"></i>
                                                    </a>
                                                </div>
                                            </div>
                                              <div class="col-xxl-4 col-md-4">

                                                <div>

                                                    <label for="basiInput" class="form-label">Haber Sürmanşet Başlığı</label>

                                                    <input type="text" id="title"  name="mainheadline_title" class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                              <div class="col-xxl-4 col-md-4">

                                                <div>

                                                    <label for="basiInput" class="form-label">Haber Manşet Başlığı</label>

                                                    <input type="text" id="title"  name="headline_title" class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                            <!--end col-->



                                            <div class="col-xxl-12 col-md-12">

                                                <div>

                                                    <label for="valueInput" class="form-label">Haber Kısa Açıklama</label>


                                                    <textarea  name="short_description" rows="4"  class="form-control" id="basiInput"> </textarea>

                                                </div>

                                            </div>

                                              <div class="col-xxl-3 col-md-3">

                                                <div>

                                                    <label for="basiInput" class="form-label">Haber Etiketleri (Virgüllü Giriniz (Örn: Ankara,Haber,Katil))</label>

                                                      <div class="input-group">
                                                    <input type="text" id="tag"  name="tag" class="form-control" placeholder="Haber Etiketleri " aria-label="Haber Etiketleri ">

                                                    <a href="javascript:void(0)" class="input-group-text" id="generate-tag" title="Yapay Zeka'dan Tag Üret" style="background: #fff; border-radius: 5px; ">
                                                        <i class="ri-robot-2-line"></i>
                                                    </a>
                                                </div>
                                                </div>

                                            </div>

                                               <div class="col-xxl-3 col-md-3">

                                                <div>

                                                    <label for="basiInput" class="form-label">Haber Slug (Seo Link)</label>

                                                    <input type="text"  id="seo-url"  name="slug" value="{{$sound->slug ?? ''}}"  class="form-control" id="basiInput">

                                                </div>

                                            </div>


                                              <div class="col-xxl-3 col-md-3">

                                                <div>

                                                    <label for="basiInput" class="form-label">Haber Kaynak</label>

                                                    <input type="text"  name="kaynak"  class="form-control" id="basiInput">

                                                </div>

                                            </div>


                                              <div class="col-xxl-3 col-md-3">

                                                <div>

                                                    <label for="basiInput" class="form-label">Haber Oluşturma Tarihi</label>

                                                    <input type="datetime-local"  name="date"  class="form-control" id="basiInput" value="{{date('Y-m-d H:i',time()+10800)}}">

                                                </div>

                                            </div>

                                            <div class="col-lg-6 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Kategori Seç</label>

                                                        <select class="form-control" required name="category_id"  id="category_id" >
                                                            <option value=""> Kategori Seç</option>
                                                            @foreach($TopCategories as $TopCategory)

                                                            <option value="{{$TopCategory->name}}">{{$TopCategory->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>

                                                 <div class="col-lg-6 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Yazar Seç</label>

                                                        <select class="form-control" required name="author_id" id="author_id">
                                                            <option value=""> Yazar Seç</option>

                                                            @foreach($Authors as $Author)

                                                            <option value="{{$Author->name}}">{{$Author->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>

                                                 <div class="col-lg-6 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Bağlantılı Foto Galeri Seç</label>

                                                        <select class="form-control"  name="photo_gallary_id"  data-choices name="photo_gallary_id" id="choices-single-default">

                                                            <option value="">Foto Galeri Bağlantısı Yok</option>

                                                            @foreach($PhotoGallary as $Photo)

                                                            <option value="{{$Photo->name}}">{{$Photo->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>

                                                  <div class="col-lg-6 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Bağlantılı Video Galeri Seç</label>

                                                        <select class="form-control"  name="video_gallary_id"  data-choices name="video_gallary_id" id="choices-single-default">

                                                            <option value="">Video Galeri Bağlantısı Yok</option>

                                                            @foreach($VideoGallary as $Video)

                                                            <option value="{{$Video->name}}">{{$Video->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>

                                                  <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Haber Aktif Mi?</label>

                                                        <select class="form-control"  name="status" id="choices-single-default">

                                                            <option value="0">Pasif Haber (Taslak)</option>
                                                            <option value="1" selected>Aktif Haber (Yayında)</option>

                                                        </select>

                                                    </div>

                                                </div>

                                                    <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Haber Tipi</label>

                                                        <select class="form-control"  name="corner_post" id="choices-single-default">

                                                            <option value="0">Normal Haber</option>
                                                            <option value="1">Köşe Yazısı</option>

                                                        </select>

                                                    </div>

                                                </div>



                                                  <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Sür Manşet Haber mi</label>

                                                        <select class="form-control"  name="is_mainheadline" id="choices-single-default">

                                                            <option value="0">Hayır</option>
                                                            <option value="1">Evet</option>

                                                        </select>

                                                    </div>

                                                </div>
                                                             <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Üst Manşet Haber mi</label>

                                                        <select class="form-control"  name="is_topheadline" id="choices-single-default">

                                                            <option value="0">Hayır</option>
                                                            <option value="1">Evet</option>

                                                        </select>

                                                    </div>

                                                </div>


                                                <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Son Dakika Haber mi</label>

                                                        <select class="form-control"  name="is_lastminute" id="choices-single-default">

                                                            <option value="0">Hayır</option>
                                                            <option value="1">Evet</option>

                                                        </select>

                                                    </div>

                                                </div>



                                                    <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Manşet Üstü Yazılar Gözüksün mü ?</label>

                                                        <select class="form-control"  name="is_headline_text" id="choices-single-default">
                                                            <option value="1">Evet</option>
                                                            <option value="0">Hayır</option>

                                                        </select>

                                                    </div>

                                                </div>

                                                 <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Manşet Haber mi</label>

                                                        <select class="form-control"  name="is_headline" id="choices-single-default">

                                                            <option value="0">Hayır</option>
                                                            <option value="1">Evet</option>

                                                        </select>

                                                    </div>

                                                </div>


                                                        <div class="col-lg-3 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Özel Haber mi</label>

                                                        <select class="form-control"  name="is_breaking" id="choices-single-default">

                                                            <option value="0">Hayır</option>
                                                            <option value="1">Evet</option>

                                                        </select>

                                                    </div>

                                                </div>





                                            <div class="col-lg-3">

                                                <div>

                                                    <label for="formSizeDefault" class="form-label">Haber Normal Görseli</label>

                                                    <p class="text-muted">Haber Normal Görseli  (875*450)</p>

                                                  <input class="form-control" name="file" id="inputImageNews" type="file">
                                                    <input type="hidden" name="croppedImagePathNews" id="croppedImagePathNews">
                                                </div>

                                            </div>

                                            <div class="col-lg-3">

                                                <div>

                                                    <label for="formSizeDefault" class="form-label">Haber Manşet Görseli</label>

                                                    <p class="text-muted">Haber Manşet Görseli  (875*450)</p>

                                                    <input class="form-control" name="fileManset" id="inputImageHeadline" type="file">
                                                    <input type="hidden" name="croppedImagePathHeadline" id="croppedImagePathHeadline">

                                                </div>

                                            </div>

                                            <div class="col-lg-3">

                                                <div>

                                                    <label for="formSizeDefault" class="form-label">Haber Kategori (Slider) Görseli</label>

                                                    <p class="text-muted">Haber  Kategori (Slider)  Görseli (875*450)</p>

                                                    <input class="form-control" name="fileSlider" id="formSizeDefault" type="file">

                                                </div>

                                            </div>


                                            <div class="col-lg-3">

                                                <div>

                                                    <label for="formSizeDefault" class="form-label">Haber Sür Manşet (Slider)  Görseli</label>

                                                    <p class="text-muted">Haber Sür Manşet (Slider)  Görseli (1200*400)</p>

                                                    <input class="form-control" name="fileMainheadline" id="inputImage" type="file">

                                                    <input type="hidden" name="croppedImagePath" id="croppedImagePath">


                                                </div>

                                            </div>
                                            <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="colorPicker" class="form-label">Sür Manşet Bar Arkaplan Rengi</label>

                                                    <input type="color" class="form-control form-control-color w-100" name="bar_background_color" id="colorPicker" value="#222222">

                                                </div>

                                            </div>

                                            <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="colorPicker" class="form-label">Sür Manşet Yazı Rengi</label>

                                                    <input type="color" class="form-control form-control-color w-100" name="bar_text_color" id="colorPicker" value="#FDCA49">

                                                </div>

                                            </div>

                                               <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="colorPicker" class="form-label">Sür Manşet Yazı</label>

                                                    <input type="text"  name="bar_text"  class="form-control" id="basiInput">

                                                </div>

                                            </div>



                                                <div class="col-lg-12">

                                                <div>

                                                 <label for="formSizeDefault" class="form-label">Haber İçeriği</label>
                                                <a class=" col-md-2 btn btn-info bg-gradient waves-effect waves-light float-right" id="generate-content" style="float:right">Haber İçeriği Özgünleştir</a>
                                                <a class=" col-md-2 btn btn-warning bg-gradient waves-effect waves-light float-right" id="generate-warning"  style="float:right;margin-right: 10px;">İmla Ve Kelime Hatalarını Gider</a>
                                                    <div style="clear:both;margin-top:10px;"></div>
                                                  <textarea name="description" id="editor" class="form-control" rows="10"></textarea>





                                                </div>

                                            </div>




                                            <div style="clear:both"></div>



                                                <div class="col-xxl-2 col-md-2">



                                                <button type="submit" class="btn btn-secondary bg-gradient waves-effect waves-light float-right" style="width: 100%;" >Haberi Ekle</button>

                                                </div>

                                            </form>

                                                @if($error==1)

                                                <div style="z-index: 11">

                                                            <div id="borderedToast4" style="float:right" class="toast toast-border-danger overflow-hidden mt-3 fade show" role="alert" aria-live="assertive" aria-atomic="true">

                                                                <div class="toast-body">

                                                                    <div class="d-flex align-items-center">

                                                                        <div class="flex-shrink-0 me-2">

                                                                            <i class="ri-alert-line align-middle"></i>

                                                                        </div>

                                                                        <div class="flex-grow-1">

                                                                            <h6 class="mb-0">Bu Mail Adresi ya da Telefon Numarası Kullanılmaktadır.</h6>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                            </div>

                                                        </div>

                                                @endif





                                            <!--end col-->

                                            <!--end col-->

                                        </div>

                                        <!--end row-->

                                    </div>



                                </div>

                            </div>

                        </div>

                        <!--end col-->

                    </div>





            </div>

        </div>

    </div>
                                                         <div class="modal fade" id="cropModal" tabindex="-1" role="dialog" aria-labelledby="cropModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="cropModalLabel">Sür Manşet Resim Kırpma</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="img-container">
                                                                    <img id="image" src="">
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-primary" id="cropAndUpload">Resmi Kırp</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                   <div class="modal fade" id="cropModalNews" tabindex="-1" role="dialog" aria-labelledby="cropModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="cropModalLabel">Haber Resim Kırpma</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="img-container">
                                                                    <img id="imageNews" src="">
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-primary" id="cropAndUploadNews">Resmi Kırp</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="modal fade" id="cropModalHeadline" tabindex="-1" role="dialog" aria-labelledby="cropModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="cropModalLabel">Haber Manşet Resim Kırpma</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="img-container">
                                                                    <img id="imageHeadline" src="">
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-primary" id="cropAndUploadHeadline">Resmi Kırp</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


       @section('style')



           <link rel="stylesheet" href="/assets/libs/dropzone/dropzone.css" type="text/css" />



<style>
    .img-container {
        max-width: 100%;
        max-height: 100%;
    }
    img {
        max-width: 100%;
    }
</style>



       @endsection





       @section('script')

            <script src="/assets/libs/dropzone/dropzone-min.js"></script>


<script src="https://cdn.tiny.cloud/1/k8eai3tssacw9dxdimwkrrst1110qcbs5drrf2gbpbdnyi8i/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

    <script src="/assets/js/pages/form-file-upload.init.js"></script>

     <script src="/assets/libs/filepond/filepond.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>

    <script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>


<!-- Summernote CSS -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">

<!-- Summernote JS -->
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/lang/summernote-tr-TR.min.js"></script>
<script>

  const example_image_upload_handler = (blobInfo, progress) => new Promise((resolve, reject) => {
      const xhr = new XMLHttpRequest();
      xhr.withCredentials = false;
      xhr.open('POST', '/upload-image?_token=' + document.querySelector('meta[name="csrf-token"]').getAttribute('content'));

      xhr.upload.onprogress = (e) => {
        progress(e.loaded / e.total * 100);
      };

      xhr.onload = () => {
        if (xhr.status === 403) {
          reject({ message: 'HTTP Error: ' + xhr.status, remove: true });
          return;
        }

        if (xhr.status < 200 || xhr.status >= 300) {
          reject('HTTP Error: ' + xhr.status);
          return;
        }

        const json = JSON.parse(xhr.responseText);

        if (!json || typeof json.location != 'string') {
          reject('Invalid JSON: ' + xhr.responseText);
          return;
        }

        resolve(json.location);
      };

      xhr.onerror = () => {
        reject('Image upload failed due to a XHR Transport error. Code: ' + xhr.status);
      };

      const formData = new FormData();
      formData.append('file', blobInfo.blob(), blobInfo.filename());

      xhr.send(formData);
    });

$(document).ready(function() {
    // Debug bilgilerini güncelle
    $('#jquery-status').text('jQuery Status: Yüklendi (' + $.fn.jquery + ')');

    // Tooltip'leri aktif hale getir
    $('[data-toggle="tooltip"]').tooltip();

    // Summernote kontrol et
    if (typeof $.fn.summernote !== 'undefined') {
        $('#summernote-status').text('Summernote Status: Yüklendi');

        // Summernote'u başlat
        $('#editor').summernote({
            height: 300,
            lang: 'tr-TR',
            placeholder: 'Haber içeriğinizi buraya yazınız...',
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontname', ['fontname']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                onImageUpload: function(files) {
                    for (let i = 0; i < files.length; i++) {
                        uploadSummernoteImage(files[i], this);
                    }
                },
                onInit: function() {
                    $('#summernote-status').text('Summernote Status: Başarıyla Başlatıldı!');
                    $('#debug-info').fadeOut(3000); // 3 saniye sonra gizle
                },
                onError: function(e) {
                    $('#summernote-status').text('Summernote Status: Hata - ' + e);
                }
            }
        });
    } else {
        $('#summernote-status').text('Summernote Status: YÜKLENEMEDİ! CDN linki kontrol edin.');
        console.error('Summernote yüklenmedi! CDN bağlantısını kontrol edin.');

        // Basit textarea olarak bırak
        $('#editor').attr('placeholder', 'Summernote yüklenemedi. Manuel metin editörü kullanılıyor...');
    }
});


</script>


  <script>
       $(document).ready(function() {
    $('#title').on('input', function() {
        var title = $(this).val();
        var seoUrl = generateSeoUrl(title);

        // Ajax ile veritabanını kontrol ediyoruz
        $.ajax({
            url: '/check-seo-url',  // Laravel'deki rotanız
            method: 'POST',
            data: {
                seo_url: seoUrl,
                _token: $('meta[name="csrf-token"]').attr('content') // CSRF tokenini ekleyin
            },
            success: function(response) {
                // Eğer URL varsa, sonuna numara ekleyelim
                if (response.exists) {
                    seoUrl += '-' + response.suffix;
                }
                $('#seo-url').val(seoUrl);  // SEO inputunu güncelle
            }
        });
    });

    function generateSeoUrl(title) {
        var trMap = {
            'ç': 'c', 'Ç': 'C',
            'ğ': 'g', 'Ğ': 'G',
            'ı': 'i', 'I': 'I',
            'İ': 'I', 'i': 'i',
            'ö': 'o', 'Ö': 'O',
            'ş': 's', 'Ş': 'S',
            'ü': 'u', 'Ü': 'U'
        };
        return title.toLowerCase()
            .replace(/[^a-z0-9\s-çğışöü]/gi, '') // Geçersiz karakterleri kaldır
            .replace(/[çğışöü]/g, function(match) { return trMap[match]; }) // Türkçe karakterleri değiştir
            .replace(/\s+/g, '-')         // Boşlukları - ile değiştir
            .replace(/-+/g, '-');         // Fazla - işaretlerini tek - yap
    }
});
    </script>


   <script>
    var cropper;
    var cropperNews;
    $(document).ready(function() {
        var image = document.getElementById('image');
        var newsimage = document.getElementById('imageNews');
        var headlineimage = document.getElementById('imageHeadline');
        var inputImage = document.getElementById('inputImage');
        var inputnewsImage = document.getElementById('inputImageNews');
        var inputnewsHeadline = document.getElementById('inputImageHeadline');

        inputImage.onchange = function(e) {
            var files = e.target.files;
            var done = function(url) {
                inputImage.value = '';
                image.src = url;
                $('#cropModal').modal('show');
            };
            var reader;
            var file;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        };
        inputnewsHeadline.onchange = function(e) {
            var files = e.target.files;
            var done = function(url) {
                inputnewsHeadline.value = '';
                headlineimage.src = url;
                $('#cropModalHeadline').modal('show');
            };
            var reader;
            var file;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        };

         inputnewsImage.onchange = function(e) {
            var files = e.target.files;
            var done = function(url) {
                inputnewsImage.value = '';
                newsimage.src = url;
                $('#cropModalNews').modal('show');
            };
            var reader;
            var file;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        };

        $('#cropModal').on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: 1200 / 400,
                viewMode: 1,
                dragMode: 'move',
                cropBoxResizable: false,
                cropBoxMovable: false,
                guides: false,
                center: false,
                highlight: false,
                background: false,
                autoCropArea: 1
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
            cropper = null;
        });


          $('#cropModalNews').on('shown.bs.modal', function() {
            cropperNews = new Cropper(imageNews, {
                aspectRatio: 800 / 450, // Aspect ratio'yu korur
                    viewMode: 1,
                    dragMode: 'move',
                    cropBoxResizable: true, // Crop box'un yeniden boyutlandırılabilir olmasını sağlar
                    cropBoxMovable: false,
                    guides: false,
                    center: false,
                    highlight: false,
                    background: false,
                    autoCropArea: 1
            });
        }).on('hidden.bs.modal', function() {
            cropperNews.destroy();
            cropperNews = null;
        });


          $('#cropModalHeadline').on('shown.bs.modal', function() {
            cropperHeadline = new Cropper(headlineimage, {
                aspectRatio: 800 / 450, // Aspect ratio'yu korur
                    viewMode: 1,
                    dragMode: 'move',
                    cropBoxResizable: true, // Crop box'un yeniden boyutlandırılabilir olmasını sağlar
                    cropBoxMovable: false,
                    guides: false,
                    center: false,
                    highlight: false,
                    background: false,
                    autoCropArea: 1
            });
        }).on('hidden.bs.modal', function() {
            cropperHeadline.destroy();
            cropperHeadline = null;
        });

        $('#cropAndUpload').on('click', function() {
            var canvas = cropper.getCroppedCanvas({
                width: 1200,
                height: 400
            });
            canvas.toBlob(function(blob) {
                var formData = new FormData();
                formData.append('croppedImage', blob, 'cropped.jpg');

                $.ajax({
                    url: '/news/upload',
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        console.log('Upload success');
                        $('#cropModal').modal('hide');
                        $('#croppedImagePath').val(response.path);
                        $('#inputImage').next('.text-success').remove();
                        $('#inputImage').after('<span class="text-success ml-2" style="font-size: 15px;font-weight: 600;">Resim Kırpılarak Seçildi</span>');
                    },
                    error: function() {
                        console.log('Upload error');
                    }
                });

            });
        });

        $('#cropAndUploadNews').on('click', function() {
            var canvas = cropperNews.getCroppedCanvas({
                width: 800,
                height: 450
            });
            canvas.toBlob(function(blob) {
                var formData = new FormData();
                formData.append('croppedImage', blob, 'cropped.jpg');
                $("#cropAndUploadNews").html("Resim Kırpılıyor");
                $.ajax({
                    url: '/news/upload/headline',
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        $("#cropAndUploadNews").html("Resim Kırpıldı");
                        $('#cropModalNews').modal('hide');
                        $('#croppedImagePathNews').val(response.path); // Gizli inputa değeri ekle
                         $('#inputImageNews').next('.text-success').remove();
                        $('#inputImageNews').after('<span class="text-success ml-2" style="font-size: 15px;font-weight: 600;">Resim Kırpılarak Seçildi</span>');
                    },
                    error: function() {
                        console.log('Upload error');
                    }
                });

            });
        });


        $('#cropAndUploadHeadline').on('click', function() {
            var canvas = cropperHeadline.getCroppedCanvas({
                width: 800,
                height: 450
            });
            canvas.toBlob(function(blob) {
                var formData = new FormData();
                formData.append('croppedImage', blob, 'cropped.jpg');
                $("#cropAndUploadHeadline").html("Resim Kırpılıyor");
                $.ajax({
                    url: '/news/upload/newsheadline',
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        $("#cropAndUploadHeadline").html("Resim Kırpıldı");
                        $('#cropModalHeadline').modal('hide');
                        $('#croppedImagePathHeadline').val(response.path); // Gizli inputa değeri ekle,
                         $('#inputImageHeadline').next('.text-success').remove();
                        $('#inputImageHeadline').after('<span class="text-success ml-2" style="font-size: 15px;font-weight: 600;">Resim Kırpılarak Seçildi</span>');
                    },
                    error: function() {
                        console.log('Upload error');
                    }
                });

            });
        });
    });
</script>
     <script>
    $('#generate-title').on('click', function() {


new PNotify({
                title: 'Başarılı',
                text: 'Yapay Zekadan Başlık Üretiliyor',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "Yapay Zekadan Başlık Üretiliyor",
            duration: 3000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();

        var title = $('#title').val(); // Mevcut başlığı al

        // AJAX isteği gönder
        $.ajax({
            url: "{{ route('get.ai.title') }}",
            type: "POST",
            data: {
                title: title
            },
             headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
            success: function(response) {
                // Gelen yeni başlığı input alanına yaz

                new PNotify({
                title: 'Başarılı',
                text: 'Başlık Üretildi',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "Başlık Üretildi",
            duration: 3000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();
                $('#title').val(response);
            },
            error: function() {
                alert("Başlık oluşturulamadı. Lütfen tekrar deneyin.");
            }
        });
    });


        $('#generate-content').on('click', function() {


new PNotify({
                title: 'Başarılı',
                text: 'Yapay Zekadan İçerik Üretiliyor',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "Yapay Zekadan İçerik Üretiliyor",
            duration: 10000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();

       var editorContent = tinymce.get('editor').getContent(); // TinyMCE'den içeriği alır

        // AJAX isteği gönder
        $.ajax({
            url: "{{ route('get.ai.editor') }}",
            type: "POST",
            data: {
                editor: editorContent
            },
             headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
            success: function(response) {
                // Gelen yeni başlığı input alanına yaz

                new PNotify({
                title: 'Başarılı',
                text: 'İçerik Üretildi',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "İçerik Üretildi",
            duration: 3000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();
                tinymce.get('editor').setContent(response);
            },
            error: function() {
                alert("İçerik oluşturulamadı. Lütfen tekrar deneyin.");
            }
        });
    });


                $('#generate-warning').on('click', function() {


new PNotify({
                title: 'Başarılı',
                text: 'Yapay Zekadan İçeriği Düzeltiyor',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "Yapay Zekadan İçeriği Düzeltiyor",
            duration: 10000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();

       var editorContent = tinymce.get('editor').getContent(); // TinyMCE'den içeriği alır

        // AJAX isteği gönder
        $.ajax({
            url: "{{ route('get.ai.warning') }}",
            type: "POST",
            data: {
                editor: editorContent
            },
             headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
            success: function(response) {
                // Gelen yeni başlığı input alanına yaz

                new PNotify({
                title: 'Başarılı',
                text: 'İçerik Düzeltildi',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "İçerik Düzeltildi",
            duration: 3000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();
                tinymce.get('editor').setContent(response);
            },
            error: function() {
                alert("İçerik düzeltilemedi. Lütfen tekrar deneyin.");
            }
        });
    });






     $('#generate-tag').on('click', function() {


new PNotify({
                title: 'Başarılı',
                text: 'Yapay Zekadan Etiket Üretiliyor',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "Yapay Zekadan Etiket Üretiliyor",
            duration: 7000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();

       var editorContent = tinymce.get('editor').getContent();
        // AJAX isteği gönder
        $.ajax({
            url: "{{ route('get.ai.tag') }}",
            type: "POST",
            data: {
                tag: editorContent
            },
             headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
            success: function(response) {
                // Gelen yeni başlığı input alanına yaz

                new PNotify({
                title: 'Başarılı',
                text: 'Etiket Üretildi',
                                addclass: "stack-bottom-right bg-success",
                            });

            Toastify({
            text: "Etiket Üretildi",
            duration: 3000,
            className:"info",
            newWindow: true,
            close: true,
            gravity: "top", // `top` or `bottom`
            position: "right", // `left`, `center` or `right`
            stopOnFocus: true, // Prevents dismissing of toast on hover
            style: {
                                background: "#66c99b",

            },
            onClick: function(){} // Callback after click
            }).showToast();
                $('#tag').val(response);
            },
            error: function() {
                alert("Etiket oluşturulamadı. Lütfen tekrar deneyin.");
            }
        });
    });
</script>
       @endsection





    @endsection
