@extends('layouts.master')



@section('title','Yorumlar')



@section('content')



   <!-- ============================================================== -->

   <div class="main-content">

        <div class="page-content">

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                            <h4 class="mb-sm-0">Yorumları Görüntüle</h4>



                            <div class="page-title-right">

                                <ol class="breadcrumb m-0">

                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Yorumlar</a></li>

                                </ol>

                            </div>



                        </div>

                    </div>

                </div>

               

                <div class="row">

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-header">

                                    <h5 class="card-title mb-0">Yorum</h5>

                                </div>

                                <div class="card-body">

                                    <table id="alternative-pagination" class="table nowrap dt-responsive align-middle table-hover table-bordered" style="width:100%">

                                        <thead>

                                            <tr>

                                                <th>ID</th>

                                                <th>Haber Adı</th>

                                                <th>Yorum Yapan Ad Soyad </th>

                                                <th>Yorum Yapan Mail </th>
                                                
                                                <th>Yorumu</th>

                                                <th>Yorum Tarihi</th>
                                                
                                                <th>Yorum Durumu</th>

                                                <th>Action</th>

                                            </tr>

                                        </thead>

                                        <tbody>



                                        @foreach($AllComments as $comment)

                                            <tr>

                                                <td>{{$comment->id ?? ''}}</td>

                                                <td>{{$comment->news->name ?? ''}}</td>
                                                
                                                <td>{{$comment->name ?? ''}}</td>

                                                <td>{{$comment->mail ?? ''}}</td>

                                                <td>{{$comment->comment  ?? ''}}</td>

                                                <td>{{$comment->created_at ?? ''}}</td>

                                                <td>@if($comment->status==1) <span class="badge bg-success-subtle text-success">Yorum Yayınlanmış </span> @else <span class="badge bg-warning-subtle text-warning"> Onay Bekliyor </span>  @endif</td>

                                                <td>

                                                    <div class="dropdown d-inline-block">

                                                        <button class="btn btn-soft-primary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">

                                                            <i class="ri-more-fill align-middle"></i>

                                                        </button>

                                                        <ul class="dropdown-menu dropdown-menu-end">

                                                            @if($comment->status==1) <li><a href="{{ route('comment.update', ['commentID' => $comment->id]) }}"  class="dropdown-item edit-item-btn"><i class="ri-pencil-fill align-bottom me-2 text-muted"></i>Yorumu Yayından Kaldır</a></li>  @else <li><a href="{{ route('comment.update', ['commentID' => $comment->id]) }}"  class="dropdown-item edit-item-btn"><i class="ri-pencil-fill align-bottom me-2 text-muted"></i>Yorumu Yayınla</a></li>  @endif

                                                            <li><a href="{{ route('comment.delete', ['commentID' => $comment->id]) }}"  class="dropdown-item edit-item-btn"><i class=" ri-file-list-3-fill align-bottom me-2 text-muted"></i> Yorumu Sil</a></li>

                                                                                                                    </ul>

                                                    </div>

                                                </td>

                                            </tr>

                                            @endforeach

                                         

                                        </tbody>

                                    </table>

                                </div>

                            </div>

                        </div><!--end col-->

                    </div><!--end row-->



            </div>

        </div>

    </div>

  







    @section('style')    

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css" />

    <!--datatable responsive css-->

    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />



    <style>

        .dropdown-item{

            cursor:pointer;

        }

      



           .colorBox {

                width: 15px;

                padding: 15px;

            }

    </style>



    @endsection

    @section('script')



    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>





    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>

    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>



    <script src="/assets/js/pages/datatables.init.js"></script>



    <script type="text/javascript">



        function changeUserType(userID){

            $("#userID").val(userID);

        }



    </script>



    @endsection



@endsection

