@extends('layouts.master')



@section('title','Kategoriler - Kategori Ekle')



@section('content')





<div class="main-content">

        <div class="page-content">

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">

                            <h4 class="mb-sm-0">Kategori Ekle</h4>



                            <div class="page-title-right">

                                <ol class="breadcrumb m-0">

                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Anasayfa</a></li>

                                    <li class="breadcrumb-item"><a href="{{ route('category.index') }}">Kategoriler Görüntüle</a></li>

                                    <li class="breadcrumb-item active">Kategori Ekle</li>

                                </ol>

                            </div>



                        </div>

                    </div>

                </div>

               

                <div class="row">

                        <div class="col-lg-12">

                            <div class="card">

                                <div class="card-header align-items-center d-flex">

                                    <h4 class="card-title mb-0 flex-grow-1">Kategoriler Bilgileri</h4>

                                   

                                </div><!-- end card header -->

                                <div class="card-body">

                                    <div class="live-preview">

                                        <form action="{{route('category.save')}}" method="POST"  enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                                        <div class="row gy-4">

                                            <div class="col-lg-4 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Üst Kategori Seç</label>

                                                        <select class="form-control" required name="top_category_id" data-choices id="choices-single-default">

                                                            <option value="0">Ana Kategori</option>

                                                            @foreach($TopCategories as $TopCategory)

                                                            <option value="{{$TopCategory->name}}">{{$TopCategory->name}}</option>

                                                            @endforeach

                                                        </select>

                                                    </div>

                                                </div>

                                            <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="basiInput" class="form-label">Kategori Adı</label>

                                                    <input type="text" name="name" required class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                            <!--end col-->

                                            <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="labelInput" class="form-label">Kategori Açıklaması</label>

                                                    <input type="text" name="description" required  class="form-control" id="labelInput">

                                                </div>

                                            </div>

                                            <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="labelInput" class="form-label">Kategori Anahtar Kelimeler</label>

                                                    <input type="text" name="keywords" required  class="form-control" id="labelInput">

                                                </div>

                                            </div>

                                             <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="basiInput" class="form-label">Kategori İkon</label>

                                                    <input type="text" name="icon" required class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                         

                                            <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="valueInput" class="form-label">Kategori Sıra</label>

                                                    <input type="text" name="code" class="form-control" id="basiInput">

                                                </div>

                                            </div>



                                            <div class="col-xxl-4 col-md-6">

                                                <div>

                                                    <label for="colorPicker" class="form-label">Kategori Rengi</label>

                                                    <input type="color" class="form-control form-control-color w-100" name="color" id="colorPicker" value="#333333">

                                                </div>

                                            </div>

                                               <div class="col-lg-4 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Kategori Durumu</label>

                                                        <select class="form-control" required name="status" id="choices-single-default">

                                                            <option value="0">Pasif</option>
                                                            <option value="1">Aktif</option>

                                                        </select>

                                                    </div>

                                                </div>


                                               <div class="col-lg-4 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Kategori Menü Görünümü</label>

                                                        <select class="form-control" required name="menu_settings" id="choices-single-default">

                                                            <option value="0">Pasif</option>
                                                            <option value="1">Aktif</option>

                                                        </select>

                                                    </div>

                                                </div>


                                          

                                                <div class="col-xxl-2 col-md-2">



                                                <button type="submit" class="btn btn-secondary bg-gradient waves-effect waves-light float-right" style="width: 100%;" >Yeni Kategori Tanımla</button>

                                                </div>

                                                @if($error==1)

                                                <div style="z-index: 11">

                                                            <div id="borderedToast4" style="float:right" class="toast toast-border-danger overflow-hidden mt-3 fade show" role="alert" aria-live="assertive" aria-atomic="true">

                                                                <div class="toast-body">

                                                                    <div class="d-flex align-items-center">

                                                                        <div class="flex-shrink-0 me-2">

                                                                            <i class="ri-alert-line align-middle"></i>

                                                                        </div>

                                                                        <div class="flex-grow-1">

                                                                            <h6 class="mb-0">Bu Mail Adresi ya da Telefon Numarası Kullanılmaktadır.</h6>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                            </div>

                                                        </div>

                                                @endif

                                          

                                            <!--end col-->

                                            <!--end col-->

                                        </div>

                                        <!--end row-->

                                    </div>

                                 

                                </div>

                            </div>

                        </div>

                        <!--end col-->

                    </div>

                

            

            </div>

        </div>

    </div>



       @section('style')   

       

           <link rel="stylesheet" href="/assets/libs/dropzone/dropzone.css" type="text/css" />

          



       @endsection

       



       @section('script')   

            <script src="/assets/libs/dropzone/dropzone-min.js"></script>



    <script src="/assets/js/pages/form-file-upload.init.js"></script>

     <script src="/assets/libs/filepond/filepond.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>

    <script src="/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>

    <script src="/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>

       @endsection





    @endsection





