@extends('layouts.master')

@section('title','Yazarlar - Yazar Düzenle')

@section('content')


<div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                            <h4 class="mb-sm-0">Yazar Düzenle</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Anasayfa</a></li>
                                    <li class="breadcrumb-item"><a href="{{ route('author.index') }}">Yazarları Görüntüle</a></li>
                                    <li class="breadcrumb-item active">Yazar Düzenle</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
               
                <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Yazar Bilgileri</h4>
                                   
                                </div><!-- end card header -->
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form action="{{route('author.update', ['authorID' => $category->id])}}" method="POST"  enctype="multipart/form-data">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                        <div class="row gy-4">
                                           
                                          <div class="col-xxl-6 col-md-6">

                                                <div>

                                                    <label for="basiInput" class="form-label">Yazar Adı</label>

                                                    <input type="text" name="name"  value="{{$category->name}}" required class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                             
                                            <div class="col-lg-6">

                                                <div>

                                                    <label for="formSizeDefault" class="form-label">Yazar Görseli</label>

                                                    <p class="text-muted">Yazar Görseli (1000x1000) Piksel Boyutlandırında Olması Gerekmektedir.</p>

                                                    <input class="form-control" name="file" id="formSizeDefault" type="file">

                                                </div>

                                            </div>



                                            <!--end col-->

                                            <div class="col-xxl-6 col-md-6">

                                                <div>

                                                    <label for="labelInput" class="form-label">Yazar Mail Adresi</label>

                                                    <input type="text" name="mail" required  value="{{$category->mail}}"  class="form-control" id="labelInput">

                                                </div>

                                            </div>

                                            <div class="col-xxl-6 col-md-6">

                                                <div>

                                                    <label for="labelInput" class="form-label">Yazar Sosyal Medya Adresi</label>

                                                    <input type="text" name="social_media"  value="{{$category->social_media}}"  required  class="form-control" id="labelInput">

                                                </div>

                                            </div>

                                             <div class="col-xxl-6 col-md-6">

                                                <div>

                                                    <label for="basiInput" class="form-label">Yazar Sıra</label>

                                                    <input type="text" name="code" value="{{$category->code}}" required class="form-control" id="basiInput">

                                                </div>

                                            </div>

                                              <div class="col-lg-6 col-md-6">

                                                    <div class="mb-3">

                                                        <label for="choices-single-default" class="form-label text-muted">Yazar Reklam Alanı (580x*120)</label>

                                                        <textarea  name="ads_side" rows="4"  class="form-control" id="basiInput">{{$category->ads_side}}</textarea>

                                                    </div>

                                                </div>
                                          
                                                <div class="col-xxl-2 col-md-2">

                                                <button type="submit" class="btn btn-secondary bg-gradient waves-effect waves-light float-right" style="width: 100%;" >Yazar Düzenle</button>

                                            </form>
                                                </div>
                                                @if($error==1)
                                                <div style="z-index: 11">
                                                            <div id="borderedToast4" style="float:right" class="toast toast-border-danger overflow-hidden mt-3 fade show" role="alert" aria-live="assertive" aria-atomic="true">
                                                                <div class="toast-body">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="flex-shrink-0 me-2">
                                                                            <i class="ri-alert-line align-middle"></i>
                                                                        </div>
                                                                        <div class="flex-grow-1">
                                                                            <h6 class="mb-0">Bu Mail Adresi ya da Telefon Numarası Kullanılmaktadır.</h6>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                @endif
                                          
                                            <!--end col-->
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                 
                                </div>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                
            
            </div>
        </div>
    </div>

       @section('style')   
       
           <link rel="stylesheet" href="/assets/libs/dropzone/dropzone.css" type="text/css" />
          

       @endsection
       

       @section('script')   
            <script src="/assets/libs/dropzone/dropzone-min.js"></script>

    <script src="/assets/js/pages/form-file-upload.init.js"></script>
     <script src="/assets/libs/filepond/filepond.min.js"></script>
    <script src="/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>
    <script src="/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>
    <script src="/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>
    <script src="/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>
       @endsection


    @endsection


