<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('videos', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id')->nullable();
            $table->string('date')->nullable();
            $table->string('time')->nullable();
            $table->string('name')->nullable();
            $table->text('short_description')->nullable();
            $table->string('iframe_link')->nullable();
            $table->integer('views_count')->nullable();
            $table->integer('status')->nullable();
            $table->string('video_image')->nullable();
            $table->string('tag')->nullable();
            $table->string('slug')->nullable();
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('videos');
    }
};
