<?php

namespace App\Utilities;

use App\Http\Controllers\Controller;

class FlashNotification extends Controller {


    protected static $message_type = NULL;
    protected static $message = NULL;



    public function __construct($message)
    {
        self::$message = $message;
    }

    public static function message($message) {
        self::$message = $message;
       return new static($message);
    }


    public function success() {
        \Session::flash("flash_success",self::$message);
        \Session::flash("flash_title",'Başarılı');
        return $this;
    }

    public function error() {
        \Session::flash("flash_error",self::$message);
        \Session::flash("flash_title",'Başarısız!');

        return $this;
    }

    public function warning() {
        \Session::flash("flash_warning",self::$message);
        \Session::flash("flash_title",'Dikkat!');

        return $this;
    }


    public function info() {
        \Session::flash("flash_info",self::$message);
        \Session::flash("flash_title",'Bilgi!');

        return $this;
    }


    public static function get() {
        $flash_messages = ['success','error','warning','info'];
        foreach ($flash_messages AS $messages)
        {
            if(\Session::has('flash_'.$messages))
            {
                return ['message' => session('flash_'.$messages), 'title' => session('flash_title'), 'type' => $messages];
            }

        }

        return Null;

    }
}

?>