<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PhotoGallery extends Model
{
    use HasFactory;
    
      protected $fillable = [
        'category_id',
        'date',
        'time',
        'name',
        'short_description',
        'views_count',
        'status',
        'gallery_image',
        'tag',
        'slug'
    ];

    public function images()
    {
        return $this->hasMany(PhotoGalleryImage::class, 'gallery_id');
    }
    
      public function Category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }
}