<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;


class NewsComment extends Model
{
    use HasFactory;

    protected $fillable = ['news_id', 'name', 'mail', 'comment', 'status', 'ip'];

    public function likes()
    {
        return $this->hasMany(NewsCommentsLike::class, 'comment_id');
    }

        public function news()
    {
        return $this->belongsTo(News::class, 'news_id');
    }
}