<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class News extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'short_description',
        'description',
        'slug',
        'date',
        'time',
        'status',
        'views_count',
        'is_headline',
        'is_lastminute',
        'is_breaking',
        'is_photogallary',
        'is_videogallary',
        'is_mainheadline',
        'is_topheadline',
        'corner_post',
        'tag',
        'kaynak',
        'bar_background_color',
        'bar_text_color',
        'bar_text',
        'mainheadline_title',
        'headline_title',
        'news_image',
        'headline_image',
        'mainheadline_image',
        'category_image',
        'category_id',
        'author_id',
        'photo_gallary_id',
        'video_gallary_id',
        'is_shared',
        'source_site',
        'original_news_id',
        'shared_at',
    ];

     public function Category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

     public function Author()
    {
        return $this->belongsTo(Authors::class, 'author_id', 'id');
    }
}
