<?php

namespace App\Http\Controllers;

use App\Models\Sound;
use App\Models\News;
use App\Models\Video;
use App\Models\SoundFiles;
use Illuminate\Http\Request;
use App\Utilities\FlashNotification;
use App\Models\Category;
use App\Models\Authors;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
class VideoController extends Controller
{
     public function index(Request $request)
    {   

     
        
        $AllSound=Video::orderBy('id','DESC')->get();
        
        return view('video.index')
        ->with('AllSound', $AllSound);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {        

        $TopCategories=Category::all();

        return view('video.create')
        ->with('error', '0')
        ->with('TopCategories', $TopCategories);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function Save(Request $request)
    {


        $name=$request->name;
        $short_description=$request->short_description;
        $category_id=$request->category_id;
        $getCategory=Category::where('name',$category_id)->first();
        $status=$request->status;
        $slug=$request->slug;
        $file=$request->file;
        $tag=$request->tag;
        $iframe_link=$request->iframe_link;

        $newSound= new Video();
       if ($request->hasFile('file')) {
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '-news.' . $extension;

            $year = date('Y');
            $month = date('m');
            $day = date('d');
            $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

            if (!file_exists(public_path($filePath))) {
                mkdir(public_path($filePath), 0755, true);
            }

            $file->move(public_path($filePath), $filename);
            $newSound->video_image = $filename;
        }


        if ($request->hasFile('video')) {
            $video = $request->file('video');
            $videoExtension = $video->getClientOriginalExtension();
            $videoFilename = time() . '-video.' . $videoExtension;
            $video->move('uploads/videos/', $videoFilename);
            $newSound->video = $videoFilename; // Veritabanındaki video alanı
        }



        $newSound->category_id=$getCategory->id ?? 0;
        $newSound->date=date('d.m.Y');
        $newSound->time=date('H:i');
        $newSound->name=$name;
        $newSound->slug=$slug;
        $newSound->short_description=$short_description;
        $newSound->status=$status;
        $newSound->tag=$tag;
        $newSound->iframe_link=$iframe_link;
        $newSound->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('video.index');
        
    }

    /**
     * Display the specified resource.
     */
    public function show(Home $home)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function Edit($soundID,Request $request)
    {




        $sound=Video::find($soundID);
        $TopCategories=Category::all();

        return view('video.edit')
        ->with('error', '0')
        ->with('sound', $sound)
        ->with('TopCategories', $TopCategories);
    }

    /**
     * Update the specified resource in storage.
     */
    public function Update($newsID,Request $request)
    {
        $name=$request->name;
        $short_description=$request->short_description;
        $category_id=$request->category_id;
        $getCategory=Category::where('name',$category_id)->first();
        $status=$request->status;
        $slug=$request->slug;
        $tag=$request->tag;
        $iframe_link=$request->iframe_link;

        $selectedSound= Video::find($newsID);
        if($request->hasfile('file'))
        {
             $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '-news.' . $extension;

            $year = date('Y');
            $month = date('m');
            $day = date('d');
            $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

            if (!file_exists(public_path($filePath))) {
                mkdir(public_path($filePath), 0755, true);
            }

            $file->move(public_path($filePath), $filename);
            $newSound->video_image = $filename;
        }


        if ($request->hasFile('video')) {
            $video = $request->file('video');
            $videoExtension = $video->getClientOriginalExtension();
            $videoFilename = time() . '-video.' . $videoExtension;
            $video->move('uploads/videos/', $videoFilename);
            $newSound->video = $videoFilename; // Veritabanındaki video alanı
        }


        
        $selectedSound->category_id=$getCategory->id ?? 0;
        $selectedSound->name=$name;
        $selectedSound->short_description=$short_description;
        $selectedSound->status=$status;
        $selectedSound->slug=$slug;
        $selectedSound->tag=$tag;
        $selectedSound->iframe_linkiframe_linktag;
        $selectedSound->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('video.index');
        }

    /**
     * Remove the specified resource from storage.
     */
      public function Delete($newsID,Request $request)

    {

       $categoryID= Video::find($newsID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('video.index');



    }
}
