<?php

namespace App\Http\Controllers;
use App\Utilities\FlashNotification;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Admin;
use Illuminate\Http\Request;

class UserController extends Controller
{

    public function loginSubmit(Request $request)
    {
        // Validate the form data
        $this->validate($request, [
            'email' => 'required',
            'password' => 'required|min:6'
        ]);

        $user = Admin::where('email', $request->email)->first();
        if ($user != NULL) {
            if (\Auth::attempt(['email' => $request->email,'password' => $request->password])){
                return redirect()->intended('home');

            }
        }

        return redirect()->back();


    }
}