<?php



namespace App\Http\Controllers;



use App\Models\Setting;
use App\Models\Category;
use App\Models\HomepageLayout;
use Illuminate\Http\Request;

use App\Utilities\FlashNotification;





class SettingController extends Controller

{

    /**

     * Display a listing of the resource.

     */

    public function index()

    {

        

        $settingStepOne=Setting::where('type',1)->get();
        $settingStepTwo=Setting::where('type',2)->get();
        $settingStepThree=Setting::where('type',3)->get();
        $headertype=Setting::where('id',56)->first();
        $topheadlinetype=Setting::where('id',61)->first();
        $newspaperstatus=Setting::where('id',58)->first();
        $visionstatus=Setting::where('id',59)->first();
        $authorsstatus=Setting::where('id',60)->first();
        $emojistatus=Setting::where('id',73)->first();
        $commentstatus=Setting::where('id',74)->first();
        $mansetstatus=Setting::where('id',75)->first();
        $tagstatus=Setting::where('id',78)->first();



        return view('settings.index')

        ->with('settingStepOne', $settingStepOne)
        ->with('settingStepTwo', $settingStepTwo)
        ->with('settingStepThree', $settingStepThree)
        ->with('visionstatus', $visionstatus)
        ->with('newspaperstatus', $newspaperstatus)
        ->with('authorsstatus', $authorsstatus)
        ->with('topheadlinetype', $topheadlinetype)
        ->with('emojistatus', $emojistatus)
        ->with('commentstatus', $commentstatus)
        ->with('headertype', $headertype)
        ->with('tagstatus', $tagstatus)
        ->with('mansetstatus', $mansetstatus);

    }

    public function Code()

    {

        

        $settingStepOne=Setting::where('type',10)->get();

        return view('settings.code')

        ->with('settingStepOne', $settingStepOne);
    }
public function Elements()
{
    $layout = HomepageLayout::first();
    $items = [];

    if ($layout && !empty($layout->layout)) {
        // JSON verisini ayrıştır
  if (is_string($layout->layout)) {
                    $layoutData = json_decode($layout->layout, true);
                } else {
                    $layoutData = $layout->layout; // Zaten bir dizi ise
                }
        // Eğer JSON geçerliyse
        if (json_last_error() === JSON_ERROR_NONE && is_array($layoutData)) {
            $items = $layoutData; // Tüm öğeleri ve orijinlerini al
        } else {
            // Hata durumunda loglama veya farklı bir işlem yapılabilir
            $items = []; // Geçersiz bir JSON ise boş bir dizi olarak bırak
        }
    }

    // Daha önce eklenmiş öğeleri hariç tutmak için kategori ve diğer öğeler listesini filtreleyin
    // items dizisinde hem item hem de origin var, bu yüzden item değerlerini almak için array_column kullanıyoruz
    $itemNames = array_column($items, 'item');

    $categories = Category::whereNotIn('name', $itemNames)->get(); // $categories modelini kendi kategoriler modelinizle değiştirin
    $otherItems = collect([
        'Sür Manşet', 'Ana Manşet', 'Üst Manşet', 'Astroloji', 'Gazeteler', 
        'Vizyondakiler', 'Foto Galeri', 'Video Galeri', 'Namaz Vakitleri  Eczane  Hava Durumu','3\'lü Haberler', 'Yazarlar'
    ])->filter(function ($item) use ($itemNames) {
        return !in_array($item, $itemNames);
    });

    return view('settings.element')
        ->with('categories', $categories)
        ->with('otherItems', $otherItems)
        ->with('items', $items); // Tüm öğeleri (item ve origin bilgisi ile) gönderiyoruz
}





    public function Update(Request $request)

    {

        $parameters = $request->except('_token'); // _token hariç tüm parametreleri al
        
        if($request->type==1){
             $parameters = $request->except('type'); // _token hariç tüm parametreleri al

            foreach ($parameters as $key => $value) {
                Setting::updateOrCreate(
                    ['key' => $key], // key'e göre eşleştir
                    ['value' => $value] // value'yu güncelle veya oluştur
                );
            }
        }
          if($request->type==2){
             $parameters = $request->except('type'); // _token hariç tüm parametreleri al

                foreach ($parameters as $key => $value) {

                if($request->hasfile($key))
                {
                    $file = $request->file($key);
                    $extenstion = $file->getClientOriginalExtension();
                    $filename = time().$extenstion;
                    $file->move('uploads/logo/', $filename);

                    // Tam URL'yi kaydet
                    $fullUrl = env('PANEL_URL') . '/uploads/logo/' . $filename;

                      Setting::updateOrCreate(
                        ['key' => $key], // key'e göre eşleştir
                        ['value' => $fullUrl] // value'yu güncelle veya oluştur
                    );
                }
              
            }
        }

           if($request->type==3){
             $parameters = $request->except('type'); // _token hariç tüm parametreleri al

            foreach ($parameters as $key => $value) {
                Setting::updateOrCreate(
                    ['key' => $key], // key'e göre eşleştir
                    ['value' => $value] // value'yu güncelle veya oluştur
                );
            }
        }


        return redirect()->back()->with('success', 'Settings updated successfully.');
        

    }



}

