<?php

namespace App\Http\Controllers;

use App\Models\Sound;
use App\Models\News;
use App\Models\Video;
use App\Models\PhotoGallery;
use App\Models\PhotoGalleryImage;
use App\Models\SoundFiles;
use Illuminate\Http\Request;
use App\Utilities\FlashNotification;
use App\Models\Category;
use App\Models\Authors;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class PhotoGalleryController extends Controller
{
       public function index(Request $request)
    {   

     
        
        $AllSound=PhotoGallery::orderBy('id','DESC')->get();
        
        return view('photo_gallery.index')
        ->with('AllSound', $AllSound);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {        

        $TopCategories=Category::all();

        return view('photo_gallery.create')
        ->with('error', '0')
        ->with('TopCategories', $TopCategories);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function Save(Request $request)
    {


        $name=$request->name;
        $short_description=$request->short_description;
        $category_id=$request->category_id;
        $getCategory=Category::where('name',$category_id)->first();
        $status=$request->status;
        $slug=$request->slug;
        $file=$request->file;
        $tag=$request->tag;
        
        $newSound= new PhotoGallery();
        if($request->hasfile('file'))
        {
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '-news.' . $extension;

            $year = date('Y');
            $month = date('m');
            $day = date('d');
            $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

            if (!file_exists(public_path($filePath))) {
                mkdir(public_path($filePath), 0755, true);
            }

            $file->move(public_path($filePath), $filename);
            $newSound->gallery_image = $filename;
        }


        $newSound->category_id=$getCategory->id ?? 0;
        $newSound->date=date('d.m.Y');
        $newSound->time=date('H:i');
        $newSound->name=$name;
        $newSound->slug=$slug;
        $newSound->short_description=$short_description;
        $newSound->status=$status;
        $newSound->tag=$tag;
        $newSound->save();

        $images = $request->file('images');
        $descriptions = $request->input('descriptions');
        $codes = $request->input('codes');
        $i=0;
        if(isset($images)){
            foreach ($images as $index => $image) {
                $i=$i+1;
                $newSoundImage = new PhotoGalleryImage();
                $file = $image;
                if($file) {
                    $extension = $file->getClientOriginalExtension();
                    $filename = time().'-'.$i.'.'.$extension;
                        $year = date('Y');
                        $month = date('m');
                        $day = date('d');
                        $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";
                        if (!file_exists(public_path($filePath))) {
                            mkdir(public_path($filePath), 0755, true);
                        }
                        $file->move(public_path($filePath), $filename);
                    $newSoundImage->image = $filename;
                    $newSoundImage->code = $codes[$index] ?? $index;
                    $newSoundImage->gallery_id = $newSound->id;
                    $newSoundImage->short_description = $descriptions[$index] ?? '';
                    $newSoundImage->save();
                }
            }
        }


        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('photogallery.index');
        
    }

    /**
     * Display the specified resource.
     */
    public function show(Home $home)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function Edit($soundID,Request $request)
    {




        $sound=PhotoGallery::find($soundID);
        $images=PhotoGalleryImage::where('gallery_id',$soundID)->orderBy('code','ASC')->get();
        $TopCategories=Category::all();

        return view('photo_gallery.edit')
        ->with('error', '0')
        ->with('sound', $sound)
        ->with('images', $images)
        ->with('TopCategories', $TopCategories);
    }

    /**
     * Update the specified resource in storage.
     */
    public function Update($newsID,Request $request)
    {
        $name=$request->name;
        $short_description=$request->short_description;
        $category_id=$request->category_id;
        $getCategory=Category::where('name',$category_id)->first();
        $status=$request->status;
        $slug=$request->slug;
        $tag=$request->tag;


        $selectedSound= PhotoGallery::find($newsID);
           if($request->hasfile('file'))
        {

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '-news.' . $extension;

            $year = date('Y');
            $month = date('m');
            $day = date('d');
            $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

            if (!file_exists(public_path($filePath))) {
                mkdir(public_path($filePath), 0755, true);
            }

            $file->move(public_path($filePath), $filename);
            $selectedSound->gallery_image = $filename;
        }

        
        $selectedSound->category_id=$getCategory->id ?? 0;
        $selectedSound->name=$name;
        $selectedSound->short_description=$short_description;
        $selectedSound->status=$status;
        $selectedSound->slug=$slug;
        $selectedSound->tag=$tag;
        $selectedSound->save();


        $selecteddescriptions = $request->input('selected-descriptions');
        $selectedcodes = $request->input('selected-codes');
        foreach ($selecteddescriptions as $index => $description) {
            $selectedSound= PhotoGalleryImage::find($index);
            $selectedSound->code = $selectedcodes[$index];
            $selectedSound->short_description = $selecteddescriptions[$index];
            $selectedSound->save();
        }

        @$images = $request->file('images');
        $descriptions = $request->input('descriptions');
        $codes = $request->input('codes');
        $i=0;
       if(isset($images)){
            foreach ($images as $index => $image) {
                $i=$i+1;
                $newSoundImage = new PhotoGalleryImage();
                $file = $image;
                     if($file) {
                    $extension = $file->getClientOriginalExtension();
                    $filename = time().'-'.$i.'.'.$extension;
                        $year = date('Y');
                        $month = date('m');
                        $day = date('d');
                        $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";
                        if (!file_exists(public_path($filePath))) {
                            mkdir(public_path($filePath), 0755, true);
                        }
                        $file->move(public_path($filePath), $filename);
                    $newSoundImage->image = $filename;
                    $newSoundImage->code = $codes[$index];
                    $newSoundImage->gallery_id = $newsID;
                    $newSoundImage->short_description = $descriptions[$index];
                    $newSoundImage->save();
                }
            }
        }


        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('photogallery.index');
        }

    /**
     * Remove the specified resource from storage.
     */
      public function Delete($newsID,Request $request)

    {

       $categoryID= PhotoGallery::find($newsID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('photogallery.index');



    }

      public function imageDelete($newsID,Request $request)

    {

       $categoryID= PhotoGalleryImage::find($newsID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->back();



    }
}
