<?php



namespace App\Http\Controllers;



use App\Models\Page;

use Illuminate\Http\Request;

use App\Utilities\FlashNotification;





class PageController extends Controller

{

    /**

     * Display a listing of the resource.

     */

    public function index()

    {

        

        $AllPages=Page::orderBy('id','ASC')->get();



        return view('pages.index')

        ->with('AllPages', $AllPages);

    }



    /**

     * Show the form for creating a new resource.

     */

    public function create()

    {




        return view('pages.create')

        ->with('error', '0');

    }



    /**

     * Store a newly created resource in storage.

     */

    public function Save(Request $request)

    {

        $name=$request->name;
        $slug=$request->slug;
        $content=$request->content;

        $newPage= new Page();
        
        $newPage->name=$name;
        $newPage->slug=$slug;
        $newPage->content=$content;
        $newPage->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('pages.index');



    }



    /**

     * Display the specified resource.

     */

    public function show(Home $home)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     */

    public function Edit($pageID,Request $request)

    {

        $page=Page::find($pageID);

        return view('pages.edit')

        ->with('error', '0')

        ->with('page', $page);

    }



    /**

     * Update the specified resource in storage.

     */

    public function Update($pageID,Request $request)

    {

        $name=$request->name;
        $slug=$request->slug;
        $content=$request->content;


        $selectedCategory= Page::find($pageID);
        $selectedCategory->name=$name;
        $selectedCategory->slug=$slug;
        $selectedCategory->content=$content;
        $selectedCategory->save();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('pages.index');

    }



    /**

     * Remove the specified resource from storage.

     */

    public function Delete($pageID,Request $request)

    {

       $categoryID= Page::find($pageID);

       $categoryID->delete();


        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('pages.index');



    }

}

