<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Utilities\FlashNotification;
use App\Models\OfficialNews;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class OfficialNewsController extends Controller
{
     public function index(Request $request)
    {   

     
        
        $AllSound=OfficialNews::orderBy('id','DESC')->get();
        
        return view('official_news.index')
        ->with('AllSound', $AllSound);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {        


        return view('official_news.create')
        ->with('error', '0');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function Save(Request $request)
    {


        $title=$request->title;
        $short_description=$request->short_description;
        $news_no=$request->news_no;
        $slug=$request->slug;
        $content=$request->content;
        $file=$request->file;

        $newSound= new OfficialNews();
       if ($request->hasFile('file')) {
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '-news.' . $extension;

            $year = date('Y');
            $month = date('m');
            $day = date('d');
            $filePath = "uploads/images/official/{$year}/{$month}/{$day}/";

            if (!file_exists(public_path($filePath))) {
                mkdir(public_path($filePath), 0755, true);
            }

            $file->move(public_path($filePath), $filename);
            $newSound->image = $filename;
        }

         $date=$request->date;
        $dateTime = new \DateTime($date);


        $newSound->title=$title;
        $newSound->news_no=$news_no;
        $newSound->date=$dateTime->format('d.m.Y');
        $newSound->time=$dateTime->format('H:i');
        $newSound->description=$short_description;
        $newSound->slug=$slug;
        $newSound->content=$content;
        $newSound->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('official.index');
        
    }

    /**
     * Display the specified resource.
     */
    public function show(Home $home)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function Edit($newsID,Request $request)
    {


        $sound=OfficialNews::find($newsID);

        return view('official_news.edit')
        ->with('error', '0')
        ->with('sound', $sound);
    }

    /**
     * Update the specified resource in storage.
     */
    public function Update($newsID,Request $request)
    {
        

        $title=$request->title;
        $short_description=$request->short_description;
        $news_no=$request->news_no;
        $slug=$request->slug;
        $content=$request->content;
        $file=$request->file;

        $selectedSound= OfficialNews::find($newsID);
        if($request->hasfile('file'))
        {
             $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '-news.' . $extension;

            $year = date('Y');
            $month = date('m');
            $day = date('d');
            $filePath = "uploads/images/official/{$year}/{$month}/{$day}/";

            if (!file_exists(public_path($filePath))) {
                mkdir(public_path($filePath), 0755, true);
            }

            $file->move(public_path($filePath), $filename);
            $selectedSound->image = $filename;
        }
        $date=$request->date;
        $dateTime = new \DateTime($date);


        $selectedSound->title=$title;
        $selectedSound->news_no=$news_no;
        $selectedSound->date=$dateTime->format('d.m.Y');
        $selectedSound->time=$dateTime->format('H:i');
        $selectedSound->description=$short_description;
        $selectedSound->slug=$slug;
        $selectedSound->content=$content;
        $selectedSound->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('official.index');
        }

    /**
     * Remove the specified resource from storage.
     */
      public function Delete($newsID,Request $request)

    {

       $categoryID= OfficialNews::find($newsID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('official.index');



    }


    public function GetOfficial(Request $request){

        $ilanno=$request->no;

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://www.ilan.gov.tr/ilan/1640354',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;

    }
}
