<?php

namespace App\Http\Controllers;

use App\Models\Sound;
use App\Models\News;
use App\Models\SoundFiles;
use Illuminate\Http\Request;
use App\Utilities\FlashNotification;
use App\Models\Category;
use App\Models\NewsComment;
use App\Models\Authors;
use App\Models\PhotoGallery;
use App\Models\Video;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;


class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {   

        if(isset($request->type)){

        $getHaber=News::where('id',$request->id)->first();
        if($request->type==1){
            $getHaber->status=$request->change;
        }
        if($request->type==2){
            $getHaber->is_lastminute=$request->change;
        }
        if($request->type==3){
            $getHaber->is_headline=$request->change;
        }
        if($request->type==4){
            $getHaber->is_breaking=$request->change;
        }
        $getHaber->save();
        }

        $name = $request->get('name');
        $author_id = $request->get('author_id');
        $category_id = $request->get('category_id');

        $query = News::query();

        if (!empty($name)) {
            $query->where(function($q) use ($name) {
                $q->where('name', 'LIKE', '%' . $name . '%')
                  ->orWhere('description', 'LIKE', '%' . $name . '%');
            });
        }

        if (!empty($author_id)) {
            $query->where('author_id', $author_id);
        }

        if (!empty($category_id)) {
            $query->where('category_id', $category_id);
        }

        $AllSound = $query->orderBy('created_at', 'DESC')->paginate(20)->appends($request->all());
        $TopCategories=Category::all();
        $Authors=Authors::all();
        
        
        return view('news.index')
        ->with('TopCategories', $TopCategories)
        ->with('Authors', $Authors)
        ->with('AllSound', $AllSound);
    }

     public function IndexMainHeadline(Request $request)
    {   

        if(isset($request->type)){

        $getHaber=News::where('id',$request->id)->first();
        if($request->type==1){
            $getHaber->status=$request->change;
        }
        if($request->type==2){
            $getHaber->is_lastminute=$request->change;
        }
        if($request->type==3){
            $getHaber->is_headline=$request->change;
        }
        if($request->type==4){
            $getHaber->is_breaking=$request->change;
        }
        $getHaber->save();
        }

        $AllSound=News::orderBy('mainheadline_order', 'asc')->orderBy('created_at', 'desc')->where('is_mainheadline',"1")->paginate(500);

        return view('news.mainheadline')
        ->with('AllSound', $AllSound);
    }

    public function IndexHeadline(Request $request)
    {   

        if(isset($request->type)){

        $getHaber=News::where('id',$request->id)->first();
        if($request->type==1){
            $getHaber->status=$request->change;
        }
        if($request->type==2){
            $getHaber->is_lastminute=$request->change;
        }
        if($request->type==3){
            $getHaber->is_headline=$request->change;
        }
        if($request->type==4){
            $getHaber->is_breaking=$request->change;
        }
        $getHaber->save();
        }

        $AllSound=News::orderBy('headline_order', 'asc')->orderBy('created_at', 'desc')->where('is_headline',"1")->paginate(100);

        return view('news.headline')
        ->with('AllSound', $AllSound);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {        

        $TopCategories=Category::all();
        if(Auth()->user()->type!=0){
            $Authors=Authors::where('type','1')->orWhere('id',Auth()->user()->author_id)->get();
        }else{
            $Authors=Authors::all();
        }

        $PhotoGallary=PhotoGallery::orderBy('id','DESC')->get();
        $VideoGallary=Video::orderBy('id','DESC')->get();
        return view('news.create')
        ->with('error', '0')
        ->with('TopCategories', $TopCategories)
        ->with('PhotoGallary', $PhotoGallary)
        ->with('VideoGallary', $VideoGallary)
        ->with('Authors', $Authors);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function Save(Request $request)
    {


        $name=$request->name;
        $short_description=$request->short_description;
        $category_id=$request->category_id;
        $getCategory=Category::where('name',$category_id)->first();
        $author_id=$request->author_id;
        $getAuthor=Authors::where('name',$author_id)->first();
        $photo_gallary_id=$request->photo_gallary_id;
        $getPhotoGallary=PhotoGallery::where('name',$photo_gallary_id)->first();
        $video_gallary_id=$request->video_gallary_id;
        $getVideoGallary=Video::where('name',$video_gallary_id)->first();
        $status=$request->status;
        $slug=$request->slug;
        $is_lastminute=$request->is_lastminute;
        $is_headline=$request->is_headline;
        $is_headline_text=$request->is_headline_text;
        $is_mainheadline=$request->is_mainheadline;
        $is_topheadline=$request->is_topheadline;
        $is_breaking=$request->is_breaking;
        $corner_post=$request->corner_post;
        $file=$request->file;
        $fileManset=$request->fileManset;
        $fileSlider=$request->fileSlider;
        $description=$request->description;
        $tag=$request->tag;
        $date=$request->date;
        $dateTime = new \DateTime($date);
        $kaynak=$request->kaynak;
        $bar_background_color=$request->bar_background_color;
        $bar_text_color=$request->bar_text_color;
        $bar_text=$request->bar_text;
        $mainheadline_title=$request->mainheadline_title;
        $headline_title=$request->headline_title;
        
        $newSound= new News();
        if ($request->has('croppedImagePathNews')) {
            $imagePath = $request->input('croppedImagePathNews');
            // Eğer tam URL değilse, tam URL oluştur
            if (strpos($imagePath, 'http') !== 0) {
                $newSound->news_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $imagePath;
            } else {
                $newSound->news_image = $imagePath;
            }
        } elseif($request->hasfile('file'))
        {
            $file = $request->file('file');
            $extenstion = $file->getClientOriginalExtension();
            $filename = slug($name).'-news.'.$extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $newSound->news_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }

         if ($request->has('croppedImagePathHeadline')) {
            $imagePath = $request->input('croppedImagePathHeadline');
            // Eğer tam URL değilse, tam URL oluştur
            if (strpos($imagePath, 'http') !== 0) {
                $newSound->headline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $imagePath;
            } else {
                $newSound->headline_image = $imagePath;
            }
        } elseif($request->hasfile('fileManset'))
        {
            $file = $request->file('fileManset');
            $extenstion = $file->getClientOriginalExtension();
            $filename = slug($name).'-manset.'.$extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $newSound->headline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }


        if ($request->has('croppedImagePathCategory')) {
            $imagePath = $request->input('croppedImagePathCategory');
            // Eğer tam URL değilse, tam URL oluştur
            if (strpos($imagePath, 'http') !== 0) {
                $newSound->category_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $imagePath;
            } else {
                $newSound->category_image = $imagePath;
            }
        } elseif ($request->hasfile('fileSlider'))
        {
            $file = $request->file('fileSlider');
            $extenstion = $file->getClientOriginalExtension();
            $filename = slug($name).'-slider.'.$extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $newSound->category_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }
        if ($request->has('croppedImagePath')) {
            $imagePath = $request->input('croppedImagePath');
            // Eğer tam URL değilse, tam URL oluştur
            if (strpos($imagePath, 'http') !== 0) {
                $newSound->mainheadline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $imagePath;
            } else {
                $newSound->mainheadline_image = $imagePath;
            }
        } elseif ($request->hasfile('fileMainheadline')) {
            $file = $request->file('fileMainheadline');
            $extenstion = $file->getClientOriginalExtension();
            $filename = slug($name) . '-mainheadline.' . $extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $newSound->mainheadline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }

        $newSound->category_id=$getCategory->id ?? 0;
        $newSound->author_id=$getAuthor->id ?? 0;
        $newSound->photo_gallary_id=$getPhotoGallary->id ?? 0;
        $newSound->video_gallary_id=$getVideoGallary->id ?? 0;
        $newSound->date = $dateTime->format('d.m.Y');
        $newSound->time = $dateTime->format('H:i');
        $newSound->name=$name;
        $newSound->mainheadline_title=$mainheadline_title;
        $newSound->headline_title=$headline_title;
        $newSound->slug=$slug;
        $newSound->short_description=$short_description;
        $newSound->description=$description;
        $newSound->status=$status;
        $newSound->is_headline=$is_headline;
        $newSound->is_headline_text=$is_headline_text;
        $newSound->is_mainheadline=$is_mainheadline;
        $newSound->is_topheadline=$is_topheadline;
        $newSound->corner_post=$corner_post;
        $newSound->is_lastminute=$is_lastminute;
        $newSound->is_breaking=$is_breaking;
        $newSound->tag=$tag;
        $newSound->kaynak=$kaynak;
        $newSound->bar_background_color=$bar_background_color;
        $newSound->bar_text_color=$bar_text_color;
        $newSound->bar_text=$bar_text;
        $newSound->is_shared=0; // Varsayılan olarak paylaşılmamış
        $newSound->source_site='local'; // Alt site kaynağı
        $newSound->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('news.index');
        
    }

public function upload(Request $request)
{
    if ($request->hasFile('croppedImage')) {
        $image = $request->file('croppedImage');
        $filename = time() . '-mainheadline.' . $image->getClientOriginalExtension();

        // Tarih bazlı dosya yolunu oluşturuyoruz
        $year = date('Y');
        $month = date('m');
        $day = date('d');
        $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

        // Klasörü oluşturuyoruz (yoksa)
        if (!file_exists(public_path($filePath))) {
            mkdir(public_path($filePath), 0755, true);
        }

        // Dosyayı taşıyoruz
        $image->move(public_path($filePath), $filename);

        return response()->json(['path' => env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename]);
    }

    return response()->json(['error' => 'Image upload failed'], 400);
}

public function uploadCategory(Request $request)
{
    if ($request->hasFile('croppedImage')) {
        $image = $request->file('croppedImage');
        $filename = time() . '-slider.' . $image->getClientOriginalExtension();

        $year = date('Y');
        $month = date('m');
        $day = date('d');
        $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

        if (!file_exists(public_path($filePath))) {
            mkdir(public_path($filePath), 0755, true);
        }

        $image->move(public_path($filePath), $filename);

        return response()->json(['path' => env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename]);
    }

    return response()->json(['error' => 'Image upload failed'], 400);
}

public function uploadHeadline(Request $request)
{
    if ($request->hasFile('croppedImage')) {
        $image = $request->file('croppedImage');
        $filename = time() . '-news.' . $image->getClientOriginalExtension();

        $year = date('Y');
        $month = date('m');
        $day = date('d');
        $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

        if (!file_exists(public_path($filePath))) {
            mkdir(public_path($filePath), 0755, true);
        }

        $image->move(public_path($filePath), $filename);

        return response()->json(['path' => env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename]);
    }

    return response()->json(['error' => 'Image upload failed'], 400);
}

public function uploadnewsHeadline(Request $request)
{
    if ($request->hasFile('croppedImage')) {
        $image = $request->file('croppedImage');
        $filename = time() . '-headline.' . $image->getClientOriginalExtension();

        $year = date('Y');
        $month = date('m');
        $day = date('d');
        $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";

        if (!file_exists(public_path($filePath))) {
            mkdir(public_path($filePath), 0755, true);
        }

        $image->move(public_path($filePath), $filename);

        return response()->json(['path' => env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename]);
    }

    return response()->json(['error' => 'Image upload failed'], 400);
}



    public function getComments(Request $request){

    $AllComments=NewsComment::orderBy('status','ASC')->get();

     return view('news.comments')

        ->with('AllComments', $AllComments);

    }


       public function commentUpdate($commentID,Request $request){

    $getComments=NewsComment::where('id',$commentID)->first();

    if($getComments->status==0){

        $getComments->status=1;
        $getComments->save();

    }else{
          $getComments->status=0;
        $getComments->save();
    }
        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

     return redirect()->back();

    }


          public function commentDelete($commentID,Request $request)

    {

       $categoryID= NewsComment::find($commentID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->back();


    }


    /**
     * Display the specified resource.
     */
    public function show(Home $home)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function Edit($soundID,Request $request)
    {




       $sound=News::find($soundID);
        $TopCategories=Category::all();
        if(Auth()->user()->type!=0){
            $Authors=Authors::where('type','1')->orWhere('id',Auth()->user()->id)->get();
        }else{
            $Authors=Authors::all();
        }
        $PhotoGallary=PhotoGallery::orderBy('id','DESC')->get();
        $VideoGallary=Video::orderBy('id','DESC')->get();

        return view('news.edit')
        ->with('error', '0')
        ->with('sound', $sound)
        ->with('Authors', $Authors)
        ->with('PhotoGallary', $PhotoGallary)
        ->with('VideoGallary', $VideoGallary)
        ->with('TopCategories', $TopCategories);
    }

    /**
     * Update the specified resource in storage.
     */
    public function Update($newsID,Request $request)
    {
        $name=$request->name;
        $short_description=$request->short_description;
        $category_id=$request->category_id;
        $getCategory=Category::where('name',$category_id)->first();
        $author_id=$request->author_id;
        $getAuthor=Authors::where('name',$author_id)->first();
        $photo_gallary_id=$request->photo_gallary_id;
        $getPhotoGallary=PhotoGallery::where('name',$photo_gallary_id)->first();
        $video_gallary_id=$request->video_gallary_id;
        $getVideoGallary=Video::where('name',$video_gallary_id)->first();
        $status=$request->status;
        $slug=$request->slug;

        $is_lastminute=$request->is_lastminute;
        $is_headline=$request->is_headline;
        $is_headline_text=$request->is_headline_text;
        $is_mainheadline=$request->is_mainheadline;
        $is_topheadline=$request->is_topheadline;
        $is_breaking=$request->is_breaking;
        $corner_post=$request->corner_post;
        $file=$request->file;
        $fileManset=$request->fileManset;
        $fileSlider=$request->fileSlider;
        $description=$request->description;
          $tag=$request->tag;
        $kaynak=$request->kaynak;
           $bar_background_color=$request->bar_background_color;
        $bar_text_color=$request->bar_text_color;
        $bar_text=$request->bar_text;    
         $mainheadline_title=$request->mainheadline_title;
        $headline_title=$request->headline_title;


        $change_date_time=$request->change_date_time;
        $changedateTime = new \DateTime($change_date_time);

        $selectedSound= News::find($newsID);
        if ($request->has('croppedImagePathNews')) {
            if($request->input('croppedImagePathNews')!=''){
                $imagePath = $request->input('croppedImagePathNews');
                // Eğer tam URL değilse, tam URL oluştur
                if (strpos($imagePath, 'http') !== 0) {
                    $selectedSound->news_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $imagePath;
                } else {
                    $selectedSound->news_image = $imagePath;
                }
                $selectedSound->date = date('d.m.Y');
                $selectedSound->time = date('H:i');
            }
        } elseif($request->hasfile('file'))
        {
            $file = $request->file('file');
            $extenstion = $file->getClientOriginalExtension();
            $filename = time().'-news.'.$extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $selectedSound->news_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }

         if ($request->has('croppedImagePathHeadline')) {
             if($request->input('croppedImagePathHeadline')!=''){
                $imagePath = $request->input('croppedImagePathHeadline');
                // Eğer tam URL değilse, tam URL oluştur
                if (strpos($imagePath, 'http') !== 0) {
                    $selectedSound->headline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $imagePath;
                } else {
                    $selectedSound->headline_image = $imagePath;
                }
             }
        }elseif($request->hasfile('fileManset'))
        {
            $file = $request->file('fileManset');
            $extenstion = $file->getClientOriginalExtension();
            $filename = time().'-manset.'.$extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $selectedSound->headline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }


        if($request->hasfile('fileSlider'))
        {
            $file = $request->file('fileSlider');
            $extenstion = $file->getClientOriginalExtension();
            $filename = time().'-slider.'.$extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $selectedSound->category_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }
           if ($request->has('croppedImagePath')) {
             if($request->input('croppedImagePath')!=''){
                $imagePath = $request->input('croppedImagePath');
                // Eğer tam URL değilse, tam URL oluştur
                if (strpos($imagePath, 'http') !== 0) {
                    $selectedSound->mainheadline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $imagePath;
                } else {
                    $selectedSound->mainheadline_image = $imagePath;
                }
             }
        } elseif ($request->hasfile('fileMainheadline')) {
            $file = $request->file('fileMainheadline');
            $extenstion = $file->getClientOriginalExtension();
            $filename = time() . '-mainheadline.' . $extenstion;
            $file->move('uploads/images/news/' . date('Y/m/d') . '/', $filename);
            $selectedSound->mainheadline_image = env('PANEL_URL') . '/uploads/images/news/' . date('Y/m/d') . '/' . $filename;
        }


        
        $selectedSound->category_id=$getCategory->id ?? 0;
        $selectedSound->author_id=$getAuthor->id ?? 0;
        $selectedSound->photo_gallary_id=$getPhotoGallary->id ?? 0;
        $selectedSound->video_gallary_id=$getVideoGallary->id ?? 0;
        $selectedSound->change_date_time=$changedateTime->format('d.m.Y H:i');
        $selectedSound->name=$name;
        $selectedSound->mainheadline_title=$mainheadline_title;
        $selectedSound->headline_title=$headline_title;
        $selectedSound->short_description=$short_description;
        $selectedSound->description=$description;
        $selectedSound->is_headline_text=$is_headline_text;
        $selectedSound->status=$status;
        $selectedSound->corner_post=$corner_post;
        $selectedSound->is_headline=$is_headline;
        $selectedSound->is_mainheadline=$is_mainheadline;
        $selectedSound->is_topheadline=$is_topheadline;
        $selectedSound->is_lastminute=$is_lastminute;
        $selectedSound->is_breaking=$is_breaking;
        $selectedSound->tag=$tag;
        $selectedSound->kaynak=$kaynak;
        $selectedSound->bar_background_color=$bar_background_color;
        $selectedSound->bar_text_color=$bar_text_color;
        $selectedSound->bar_text=$bar_text;
        $selectedSound->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();
        return redirect()->route('news.index');
        }

    /**
     * Remove the specified resource from storage.
     */
      public function Delete($newsID,Request $request)

    {

       $categoryID= News::find($newsID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('news.index');



    }

        public function EditorUpload(Request $request)
        {
            $validator = Validator::make($request->all(), [
                'file' => 'required|image|mimes:jpeg,png,jpg,gif,svg,webp|max:20480', // Sadece resim dosyaları kabul edilir
            ]);

            // Validasyon hatası varsa
            if ($validator->fails()) {
                return response()->json([
                    'uploaded' => false,
                    'error' => [
                        'message' => $validator->errors()->first('file')
                    ]
                ]);
            }

            if ($request->hasFile('file')) {
                $file = $request->file('file');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                
                // Tarihe göre dosya yolunu oluşturuyoruz
                $year = date('Y');
                $month = date('m');
                $day = date('d');
                $filePath = "uploads/images/news/{$year}/{$month}/{$day}/";
                
                // Dizini oluşturmak için kontrol ediyoruz
                if (!file_exists(public_path($filePath))) {
                    mkdir(public_path($filePath), 0755, true); // Dizin yoksa oluştur
                }

                // Dosyayı belirlenen klasöre taşı
                $file->move(public_path($filePath), $filename);

                // Yüklenen dosyanın URL'si
                $url = '/' . $filePath . $filename;

                // Yüklenen resmin URL'sini CKEditor'a geri gönder
                return response()->json([
                    'uploaded' => true,
                    'location' => $url
                ]);
            } else {
                return response()->json([
                    'uploaded' => false,
                    'error' => [
                        'message' => 'No file uploaded.'
                    ]
                ]);
            }
}


    public function UpdateMainHeadline(Request $request)
    {
        $order = $request->input('order');

        if ($order && is_array($order)) {
            foreach ($order as $position => $id) {
               News::where('id', $id)
                    ->update(['mainheadline_order' => $position + 1]);
            }
            return response()->json(['status' => 'success']);
        }

        return response()->json(['status' => 'error'], 400);
    }
        public function UpdateHeadline(Request $request)
    {
        $order = $request->input('order');

        if ($order && is_array($order)) {
            foreach ($order as $position => $id) {
               News::where('id', $id)
                    ->update(['headline_order' => $position + 1]);
            }
            return response()->json(['status' => 'success']);
        }

        return response()->json(['status' => 'error'], 400);
    }


     public function checkSeoUrl(Request $request)
    {
        $seoUrl = $request->input('seo_url');
        $exists = News::where('slug', $seoUrl)->exists(); // Veritabanında olup olmadığını kontrol ediyoruz

        if ($exists) {
            // Eğer URL kullanılıyorsa sonuna bir numara ekleyelim
            $count = News::where('slug', 'LIKE', "{$seoUrl}%")->count();
            return response()->json(['exists' => true, 'suffix' => $count + 1]);
        }

        return response()->json(['exists' => false]);
    }


public function getAITitle(Request $request)
{
    $curlheader = curl_init();

    curl_setopt_array($curlheader, array(
        CURLOPT_URL => 'https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=AIzaSyBL3HEeBODwjnEvbgwWC3EYkzSKmqArWPM',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode([
            "contents" => [
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => "Sana Bir Haber Başlığı Paylaşacağım. Bu Haber Başlığını Özgünleştirmeni İstiyorum. Sadece Bir Cümlelik Bir Haber Başlığı İstiyorum. Direk Haber Başlığını Paylaş"]
                    ]
                ],
                [
                    "role" => "model",
                    "parts" => [
                        ["text" => "Haberi Başlığı için lütfen bana haberin başlığını verin."]
                    ]
                ],
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => $request->title]
                    ]
                ]
            ],
            "safetySettings" => [
                [
                    "category" => "HARM_CATEGORY_DANGEROUS_CONTENT",
                    "threshold" => "BLOCK_ONLY_HIGH"
                ]
            ],
            "generationConfig" => [
                "stopSequences" => ["Title"],
                "temperature" => 1.0,
                "maxOutputTokens" => 12000,
                "topP" => 0.8,
                "topK" => 10
            ]
        ]),
        CURLOPT_HTTPHEADER => array('Content-Type: application/json'),
    ));

    $curlResponse = curl_exec($curlheader);
    curl_close($curlheader);

    $curlresult = json_decode($curlResponse);

    if (isset($curlresult)) {
        $TitleresultMessage = $curlresult->candidates[0]->content->parts[0]->text ?? $request->title;
        $TitleresultMessage = str_replace(array("\n", "\r"), "<br/>", $TitleresultMessage);
        $TitleresultMessage = str_replace('*', '', $TitleresultMessage);
        $newTitle = $TitleresultMessage;
    } else {
        $newTitle = $request->title; // Başlık oluşturulamazsa orijinal başlığı kullan
    }

    return response()->json($newTitle);
}



public function getAIContent(Request $request)
{

    $curlheader = curl_init();

    curl_setopt_array($curlheader, array(
        CURLOPT_URL => 'https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=AIzaSyBL3HEeBODwjnEvbgwWC3EYkzSKmqArWPM',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode([
            "contents" => [
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => "Sana Bir Haber İçeriği Paylaşacağım. Bu Haber İçeriği Özgünleştirmeni İstiyorum. Lütfen Haber İçeriğin Anlamını Değiştirme. Daha eş anlamlı ve Güzel kelimeler seçerek özelleştir. Direk Haber İçeriği Paylaş. Özgünleştirilmiş Haber İçeriği: yazma direk haberi ver. "]
                    ]
                ],
                [
                    "role" => "model",
                    "parts" => [
                        ["text" => "Haberi İçeriği için lütfen bana haberin başlığını verin."]
                    ]
                ],
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => $request->editor]
                    ]
                ]
            ],
            "safetySettings" => [
                [
                    "category" => "HARM_CATEGORY_DANGEROUS_CONTENT",
                    "threshold" => "BLOCK_ONLY_HIGH"
                ]
            ],
            "generationConfig" => [
                "stopSequences" => ["Title"],
                "temperature" => 1.0,
                "maxOutputTokens" => 12000,
                "topP" => 0.8,
                "topK" => 10
            ]
        ]),
        CURLOPT_HTTPHEADER => array('Content-Type: application/json'),
    ));

    $curlResponse = curl_exec($curlheader);
    curl_close($curlheader);

    $curlresult = json_decode($curlResponse);

    if (isset($curlresult)) {
        $TitleresultMessage = $curlresult->candidates[0]->content->parts[0]->text ?? $request->title;
        $TitleresultMessage = str_replace(array("\n", "\r"), "<br/>", $TitleresultMessage);
        $TitleresultMessage = str_replace('*', '', $TitleresultMessage);
        $newTitle = $TitleresultMessage;
        $newTitle=str_replace('Özgünleştirilmiş Haber İçeriği:','',$newTitle);

    } else {
        $newTitle = $request->title; // Başlık oluşturulamazsa orijinal başlığı kullan
    }

    return response()->json($newTitle);
}

public function getAIWarning(Request $request)
{

    $curlheader = curl_init();

    curl_setopt_array($curlheader, array(
        CURLOPT_URL => 'https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=AIzaSyBL3HEeBODwjnEvbgwWC3EYkzSKmqArWPM',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode([
            "contents" => [
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => "Sana Bir Haber İçeriği Paylaşacağım. Bu Haber İçeriğinde sadece kelime hatalarını ve imla hatalarını düzeltmeni İstiyorum. Lütfen Haber İçeriğini değiştirme.Sadece ama sadece kelime ve imla hatalarını düzelt. ve Direk Haber İçeriği Paylaş. Düzenlenmiş Haber İçeriği: yazma direk haber içeriğini ver. İçeriğe bir kelime dahi eklime. Direk sana verdiğim paragrafları düzenle ve ver "]
                    ]
                ],
                [
                    "role" => "model",
                    "parts" => [
                        ["text" => "Haberi İçeriği için lütfen bana haberin başlığını verin."]
                    ]
                ],
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => $request->editor]
                    ]
                ]
            ],
            "safetySettings" => [
                [
                    "category" => "HARM_CATEGORY_DANGEROUS_CONTENT",
                    "threshold" => "BLOCK_ONLY_HIGH"
                ]
            ],
            "generationConfig" => [
                "stopSequences" => ["Title"],
                "temperature" => 1.0,
                "maxOutputTokens" => 12000,
                "topP" => 0.8,
                "topK" => 10
            ]
        ]),
        CURLOPT_HTTPHEADER => array('Content-Type: application/json'),
    ));

    $curlResponse = curl_exec($curlheader);
    curl_close($curlheader);

    $curlresult = json_decode($curlResponse);

    if (isset($curlresult)) {
        $TitleresultMessage = $curlresult->candidates[0]->content->parts[0]->text ?? $request->title;
        $TitleresultMessage = str_replace(array("\n", "\r"), "<br/>", $TitleresultMessage);
        $TitleresultMessage = str_replace('*', '', $TitleresultMessage);
        $newTitle = $TitleresultMessage;
        $newTitle=str_replace('Düzenlenmiş Haber İçeriği:','',$newTitle);
    } else {
        $newTitle = $request->title; // Başlık oluşturulamazsa orijinal başlığı kullan
    }

    return response()->json($newTitle);
}


public function getAITag(Request $request)
{

    $curlheader = curl_init();

    curl_setopt_array($curlheader, array(
        CURLOPT_URL => 'https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=AIzaSyBL3HEeBODwjnEvbgwWC3EYkzSKmqArWPM',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode([
            "contents" => [
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => "Sana Bir Haber İçeriği Paylaşacağım. Bu Haber Başlığını ile 5 Tane Etiket Üretmeni İstiyoru. Sadece Beştane Etiket İstiyorum. Etiketler # kullanma, Etiketler arası , koy Direk Haber Etiketini Paylaş , etiketler arasına </br> koyma "]
                    ]
                ],
                [
                    "role" => "model",
                    "parts" => [
                        ["text" => "Haberi Etiketi için lütfen bana haberin etiketini verin."]
                    ]
                ],
                [
                    "role" => "user",
                    "parts" => [
                        ["text" => $request->tag]
                    ]
                ]
            ],
            "safetySettings" => [
                [
                    "category" => "HARM_CATEGORY_DANGEROUS_CONTENT",
                    "threshold" => "BLOCK_ONLY_HIGH"
                ]
            ],
            "generationConfig" => [
                "stopSequences" => ["Title"],
                "temperature" => 1.0,
                "maxOutputTokens" => 12000,
                "topP" => 0.8,
                "topK" => 10
            ]
        ]),
        CURLOPT_HTTPHEADER => array('Content-Type: application/json'),
    ));

    $curlResponse = curl_exec($curlheader);
    curl_close($curlheader);

    $curlresult = json_decode($curlResponse);

    if (isset($curlresult)) {
        $TitleresultMessage = $curlresult->candidates[0]->content->parts[0]->text ?? $request->title;
        $TitleresultMessage = str_replace('<br/>', ",", $TitleresultMessage);
        $TitleresultMessage = str_replace('#', ",", $TitleresultMessage);
        $TitleresultMessage = str_replace('*', '', $TitleresultMessage);
        $newTitle = $TitleresultMessage;
        $newTitle=str_replace('</br>','',$newTitle);
    } else {
        $newTitle = $request->tag; // Başlık oluşturulamazsa orijinal başlığı kullan
    }

    return response()->json($newTitle);
}


    public function sentNotification($newsID){

        $news=News::where('id',$newsID)->first();

        $curl = curl_init();

        $short_description="";

        if($news->short_description==''){
            $short_description='-';
        }else{
            $short_description=$news->short_description;
        }


        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.onesignal.com/notifications',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
          "app_id": "'.config('settings.onesignal_push_app_id').'",
          "target_channel": "push",
          "contents": {"en": "'.$short_description.'"},
          "headings": {"en": "'.$news->name.'"},
          "url":"'.env('SITE_URL').$news->slug.'.html",
          "chrome_big_picture":"'.env('SITE_URL').'/uploads/images/news/'.date("Y/m/d", strtotime($news->date)).'/'.$news->news_image.'",
          "big_picture":"'.env('SITE_URL').'/uploads/images/news/'.date("Y/m/d", strtotime($news->date)).'/'.$news->news_image.'",
          "chrome_web_image":"'.env('SITE_URL').'/uploads/images/news/'.date("Y/m/d", strtotime($news->date)).'/'.$news->news_image.'",
          "adm_big_picture":"'.env('SITE_URL').'/uploads/images/news/'.date("Y/m/d", strtotime($news->date)).'/'.$news->news_image.'",
          "included_segments": ["All"]
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Basic '.config('settings.onesignal_push_api_key')
          ),
        ));

 


        $response = curl_exec($curl);

        curl_close($curl);
       return redirect()->back();

    }


}
