<?php



namespace App\Http\Controllers;



use App\Models\Menu;

use Illuminate\Http\Request;

use App\Utilities\FlashNotification;





class MenuController extends Controller

{

    /**

     * Display a listing of the resource.

     */

    public function index()

    {

        

        $AllPages=Menu::orderBy('id','ASC')->get();



        return view('menus.index')

        ->with('AllPages', $AllPages);

    }



    /**

     * Show the form for creating a new resource.

     */

    public function create()

    {




        return view('menus.create')

        ->with('error', '0');

    }



    /**

     * Store a newly created resource in storage.

     */

    public function Save(Request $request)

    {

        $title=$request->title;
        $link=$request->link;
        $type=$request->type;
        $page_order=$request->page_order;

        $newPage= new Menu();
        
        $newPage->title=$title;
        $newPage->link=$link;
        $newPage->type=$type;
        $newPage->page_order=$page_order;
        $newPage->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('menus.index');



    }



    /**

     * Display the specified resource.

     */

    public function show(Home $home)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     */

    public function Edit($menuID,Request $request)

    {

        $page=Menu::find($menuID);

        return view('menus.edit')

        ->with('error', '0')

        ->with('page', $page);

    }



    /**

     * Update the specified resource in storage.

     */

    public function Update($menuID,Request $request)

    {
        $title=$request->title;
        $link=$request->link;
        $type=$request->type;
        $page_order=$request->page_order;

        $selectedCategory= Menu::find($menuID);
        $selectedCategory->title=$title;
        $selectedCategory->link=$link;
        $selectedCategory->type=$type;
        $selectedCategory->page_order=$page_order;
        $selectedCategory->save();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('menus.index');

    }



    /**

     * Remove the specified resource from storage.

     */

    public function Delete($menuID,Request $request)

    {

       $categoryID= Menu::find($menuID);

       $categoryID->delete();


        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('menus.index');



    }

}

