<?php



namespace App\Http\Controllers;



use App\Models\Authors;
use App\Models\Admin;
use Illuminate\Support\Facades\Hash;

use Illuminate\Http\Request;

use App\Utilities\FlashNotification;





class EditorController extends Controller

{

    /**

     * Display a listing of the resource.

     */

    public function index()

    {

        

        $AllCategory=Authors::where('type','0')->orderBy('id','ASC')->get();



        return view('editors.index')

        ->with('AllCategory', $AllCategory);

    }



    /**

     * Show the form for creating a new resource.

     */

    public function create()

    {




        return view('editors.create')

        ->with('error', '0');

    }



    /**

     * Store a newly created resource in storage.

     */

    public function Save(Request $request)

    {

         if (Admin::where('email', $request->mail)->exists()) {
            $notification = FlashNotification::message("Bu Editor Mail Adresi Zaten kayıtlı. Lütfen Değiştirerek Tekrar Deneyiniz");
            $notification->error();
            return redirect()->back()->with('error', 'Bu Editor  Mail Adresi Zaten kayıtlı.');
        }

        $name=$request->name;
        $mail=$request->mail;
        $code=$request->code;
        $social_media=$request->social_media;
        $file=$request->file;

        $newCategory= new Authors();

        if($request->hasfile('file'))

        {

            $file = $request->file('file');

            $extenstion = $file->getClientOriginalExtension();

            $filename = time().'.'.$extenstion;

            $file->move('uploads/images/', $filename);

            $newCategory->image = $filename;

        }
        $newCategory->name=$name;

        $newCategory->mail=$mail;
        $newCategory->code=$code;
        $newCategory->type=0;
        $newCategory->social_media=$social_media;

        $newCategory->save();

        $user = new Admin();
        $user->name = $name;
        $user->email = $mail;
        $user->password = bcrypt($request->account_password); // Şifreyi hash'leyerek kaydetme
        $user->type = 1; // Mağaza kullanıcı tipi
        $user->author_id = $newCategory->id; // Mağaza ID ile bağlantı
        $user->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('editor.index');



    }



    /**

     * Display the specified resource.

     */

    public function show(Home $home)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     */

    public function Edit($categoryID,Request $request)

    {

        $category=Authors::find($categoryID);

        return view('editors.edit')

        ->with('error', '0')

        ->with('category', $category);

    }



    /**

     * Update the specified resource in storage.

     */

    public function Update($categoryID,Request $request)

    {



        
  $name=$request->name;
        $mail=$request->mail;
        $code=$request->code;
        $social_media=$request->social_media;

        $file=$request->file;


        

        $selectedCategory= Authors::find($categoryID);



        if($request->hasfile('file'))

        {

            $file = $request->file('file');

            $extenstion = $file->getClientOriginalExtension();

            $filename = time().'.'.$extenstion;

            $file->move('uploads/images/', $filename);

            $selectedCategory->image = $filename;

        }

        $selectedCategory->name=$name;
        $selectedCategory->type=0;
        $selectedCategory->mail=$mail;
        $selectedCategory->code=$code;
        $selectedCategory->social_media=$social_media;


        $selectedCategory->save();

        $user = Admin::where('author_id', $categoryID)->first();

            if($request->mail!=$user->email) {
                if (User::where('email', $request->mail)->exists()) {
                    $notification = FlashNotification::message("Bu Editör Mail Adresi Zaten kayıtlı. Lütfen Değiştirerek Tekrar Deneyiniz");
                    $notification->error();
                    return redirect()->back()->with('error', 'Bu Editör Kullanıcı Mail Adresi Zaten kayıtlı.');
                }
            }

            $user->name = $request->name;
            $user->email = $request->mail;
            if (isset($request->account_password)) {
                $user->password =  Hash::make($request->account_password); // Şifreyi hash'leyerek kaydetme
            }
            $user->save();

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('editor.index');

    }



    /**

     * Remove the specified resource from storage.

     */

    public function Delete($categoryID,Request $request)

    {


       $categoryID= Authors::find($categoryID);
       $user = Admin::where('author_id',$categoryID->id)->first();
       $user->delete();
       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('editor.index');



    }

}

