<?php



namespace App\Http\Controllers;



use App\Models\Category;

use Illuminate\Http\Request;

use App\Utilities\FlashNotification;





class CategoryController extends Controller

{

    /**

     * Display a listing of the resource.

     */

    public function index()

    {

        $AllCategory=Category::orderBy('id','ASC')->get();



        return view('categories.index')

        ->with('AllCategory', $AllCategory);

    }



    /**

     * Show the form for creating a new resource.

     */

    public function create()

    {

        $TopCategories=Category::where('top_category_id',0)->get();



        return view('categories.create')

        ->with('error', '0')

        ->with('TopCategories', $TopCategories);

    }



    /**

     * Store a newly created resource in storage.

     */

    public function Save(Request $request)

    {

        $name=$request->name;
        $description=$request->description;
        $keywords=$request->keywords;
        $icon=$request->icon;
        $code=$request->code;
        $menu_settings=$request->menu_settings;
        $status=$request->status;
        $color=$request->color;
        $color=str_replace('#', '', $color);
        $category_id=$request->top_category_id;
        $getCategory=Category::where('name',$category_id)->first();

        $newCategory= new Category();

        $newCategory->name=$name;

        $newCategory->description=$description;
        $newCategory->keywords=$keywords;
        $newCategory->icon=$icon;
        $newCategory->menu_settings=$menu_settings;
        $newCategory->status=$status;

        $newCategory->code=$code;

        $newCategory->color=$color;

        $newCategory->top_category_id=$getCategory->id ?? 0;

        $newCategory->save();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('category.index');



    }



    /**

     * Display the specified resource.

     */

    public function show(Home $home)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     */

    public function Edit($categoryID,Request $request)

    {

        $category=Category::find($categoryID);

        $TopCategories=Category::where('top_category_id',0)->get();





        return view('categories.edit')

        ->with('error', '0')

        ->with('category', $category)

        ->with('TopCategories', $TopCategories);

    }



    /**

     * Update the specified resource in storage.

     */

    public function Update($categoryID,Request $request)

    {



        

         $name=$request->name;
        $description=$request->description;
        $keywords=$request->keywords;
        $icon=$request->icon;
        $code=$request->code;
        $menu_settings=$request->menu_settings;
        $headline_side_one=$request->headline_side_one;
        $headline_side_two=$request->headline_side_two;
        $category_top_banner=$request->category_top_banner;
        $homepage_category_bottom_ads=$request->homepage_category_bottom_ads;
        $status=$request->status;
        $color=$request->color;
        $color=str_replace('#', '', $color);
        $category_id=$request->top_category_id;
        $getCategory=Category::where('name',$category_id)->first();

        $selectedCategory= Category::find($categoryID);

        $selectedCategory->name=$name;

        $selectedCategory->description=$description;
        $selectedCategory->keywords=$keywords;
        $selectedCategory->icon=$icon;
        $selectedCategory->menu_settings=$menu_settings;
        $selectedCategory->status=$status;

        $selectedCategory->code=$code;

        $selectedCategory->color=$color;

        $selectedCategory->top_category_id=$getCategory->id ?? 0;


        $selectedCategory->save();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('category.index');

    }



    /**

     * Remove the specified resource from storage.

     */

    public function Delete($categoryID,Request $request)

    {

       $categoryID= Category::find($categoryID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('category.index');



    }

}

