<?php



namespace App\Http\Controllers;



use App\Models\Authors;

use Illuminate\Http\Request;

use App\Utilities\FlashNotification;





class AuthorController extends Controller

{

    /**

     * Display a listing of the resource.

     */

    public function index()

    {

        

        $AllCategory=Authors::where('type','1')->orderBy('id','ASC')->get();



        return view('authors.index')

        ->with('AllCategory', $AllCategory);

    }



    /**

     * Show the form for creating a new resource.

     */

    public function create()

    {




        return view('authors.create')

        ->with('error', '0');

    }



    /**

     * Store a newly created resource in storage.

     */

    public function Save(Request $request)

    {

        $name=$request->name;
        $mail=$request->mail;
        $code=$request->code;
        $social_media=$request->social_media;
        $file=$request->file;

        $newCategory= new Authors();

        if($request->hasfile('file'))

        {

            $file = $request->file('file');

            $extenstion = $file->getClientOriginalExtension();

            $filename = time().'.'.$extenstion;

            $file->move('uploads/images/', $filename);

            $newCategory->image = $filename;

        }
        $newCategory->name=$name;
        $newCategory->mail=$mail;
        $newCategory->code=$code;
        $newCategory->type=1;
        $newCategory->social_media=$social_media;

        $newCategory->save();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('author.index');



    }



    /**

     * Display the specified resource.

     */

    public function show(Home $home)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     */

    public function Edit($categoryID,Request $request)

    {

        $category=Authors::find($categoryID);

        return view('authors.edit')

        ->with('error', '0')

        ->with('category', $category);

    }



    /**

     * Update the specified resource in storage.

     */

    public function Update($categoryID,Request $request)

    {



        
  $name=$request->name;
        $mail=$request->mail;
        $code=$request->code;
        $social_media=$request->social_media;
        $ads_side=$request->ads_side;

        $file=$request->file;


        

        $selectedCategory= Authors::find($categoryID);



        if($request->hasfile('file'))

        {

            $file = $request->file('file');

            $extenstion = $file->getClientOriginalExtension();

            $filename = time().'.'.$extenstion;

            $file->move('uploads/images/', $filename);

            $selectedCategory->image = $filename;

        }

        $selectedCategory->name=$name;
        $selectedCategory->type=1;
        $selectedCategory->ads_side=$ads_side;

        $selectedCategory->mail=$mail;
        $selectedCategory->code=$code;
        $selectedCategory->social_media=$social_media;


        $selectedCategory->save();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('author.index');

    }



    /**

     * Remove the specified resource from storage.

     */

    public function Delete($categoryID,Request $request)

    {

       $categoryID= Authors::find($categoryID);

       $categoryID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('author.index');



    }

}

