<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Category;
use App\Models\AgencyBotCategory;



class AgencyBotController extends Controller
{
    

    public function ihaindex()

    {


        $settingStepFour=Setting::where('type',4)->get();
        $settingsCity=Setting::where('type',99)->first();
        $BotCategories=AgencyBotCategory::where('bot_id',1)->get();
        $OurCategories=Category::all();

        return view('agencybot.iha')

        ->with('settingStepFour', $settingStepFour)
        ->with('settingsCity', $settingsCity)
        ->with('OurCategories', $OurCategories)
        ->with('BotCategories', $BotCategories);

    }


    public function aaindex()

    {


        $settingStepFour=Setting::where('type',5)->get();
        $BotCategories=AgencyBotCategory::where('bot_id',2)->get();
        $OurCategories=Category::all();

        return view('agencybot.aa')

        ->with('settingStepFour', $settingStepFour)
        ->with('OurCategories', $OurCategories)
        ->with('BotCategories', $BotCategories);

    }


      public function ihaupdate(Request $request)

    {
        $city=$request->city;
        $parameters = $request->except('_token'); // _token hariç tüm parametreleri al
        $parameters = $request->except('city'); // _token hariç tüm parametreleri al
            
        if($request->type==1){
             $parameters = $request->except('type'); // _token hariç tüm parametreleri al
            foreach ($parameters as $key => $value) {

                if($key!='city'){
                    if($value!=''){
                        Setting::updateOrCreate(
                            ['key' => $key], // key'e göre eşleştir
                            ['value' => $value] // value'yu güncelle veya oluştur
                        );
                    }
                }
            }

           $formattedCities = implode(',', array_map(function($value) {
                // Her değeri 2 karakterli hale getiriyoruz (başına 0 ekliyoruz).
                return str_pad($value, 2, "0", STR_PAD_LEFT);
            }, $city));
            Setting::updateOrCreate(
                            ['key' => 'iha_bot_city'], // key'e göre eşleştir
                            ['value' => $formattedCities] // value'yu güncelle veya oluştur
                        );
        }
          if($request->type==2){
             $parameters = $request->except('type'); // _token hariç tüm parametreleri al
             $category_id=$request->category_id;
             $bot_category_status=$request->bot_category_status;
             $bot_artificial_intelligence_status=$request->bot_artificial_intelligence_status;

            foreach ($category_id as $key => $value) {

                $duzenle=AgencyBotCategory::where('id',$key)->update(['category_id'=>$category_id[$key], 'bot_category_status' => $bot_category_status[$key], 'bot_artificial_intelligence_status' => $bot_artificial_intelligence_status[$key]]);
            }
        }

        return redirect()->back()->with('success', 'Settings updated successfully.');
        

    }

        public function aaupdate(Request $request)

    {

        $parameters = $request->except('_token'); // _token hariç tüm parametreleri al
        
        if($request->type==1){
             $parameters = $request->except('type'); // _token hariç tüm parametreleri al

            foreach ($parameters as $key => $value) {
                if($value!=''){
                    Setting::updateOrCreate(
                        ['key' => $key], // key'e göre eşleştir
                        ['value' => $value] // value'yu güncelle veya oluştur
                    );
                }
            }
        }
          if($request->type==2){
             $parameters = $request->except('type'); // _token hariç tüm parametreleri al
             $category_id=$request->category_id;
             $bot_category_status=$request->bot_category_status;
             $bot_artificial_intelligence_status=$request->bot_artificial_intelligence_status;

            foreach ($category_id as $key => $value) {

                $duzenle=AgencyBotCategory::where('id',$key)->update(['category_id'=>$category_id[$key], 'bot_category_status' => $bot_category_status[$key], 'bot_artificial_intelligence_status' => $bot_artificial_intelligence_status[$key]]);
            }
        }

        return redirect()->back()->with('success', 'Settings updated successfully.');
        

    }

}
