<?php



namespace App\Http\Controllers;



use App\Models\Ads;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Utilities\FlashNotification;
use Illuminate\Support\Facades\File;




class AdsController extends Controller

{

    /**

     * Display a listing of the resource.

     */

    public function index()

    {

        

        $AllAds=Ads::orderBy('id','ASC')->get();



        return view('ads.index')

        ->with('AllAds', $AllAds);

    }



    /**

     * Show the form for creating a new resource.

     */

    public function create()

    {

         $categories=Category::orderBy('id','ASC')->get();


        return view('ads.create')
        ->with('categories', $categories)
        ->with('error', '0');

    }



    /**

     * Store a newly created resource in storage.

     */

    public function Save(Request $request)

    {

        $categories=null;
        $ads_channel=null;
        if($request->has('reklam_alani')){
        $ads_channel = implode(',', $request->input('reklam_alani'));
        }
        if($request->has('categories')){
            $categories = implode(',', $request->input('categories'));
        }
        // Dosya yükleme yolu
        $destinationPath = public_path('/uploads/ads');

        // Hedef klasör yoksa oluştur
        if (!File::exists($destinationPath)) {
            File::makeDirectory($destinationPath, 0777, true, true);
        }

        // Resmi kaydet
        $imgFileName = null;
        $mobileImgFileName = null;

        if ($request->hasFile('img')) {
            $imgFileName = $request->file('img')->getClientOriginalName();
            $request->file('img')->move($destinationPath, $imgFileName);
        }

        if ($request->hasFile('mobile_img')) {
            $mobileImgFileName = $request->file('mobile_img')->getClientOriginalName();
            $request->file('mobile_img')->move($destinationPath, $mobileImgFileName);
        }

        // Ad modelini kullanarak veritabanına kaydetmek
        $ad = Ads::create([
            'title' => $request->input('title'),
            'desktop' => $request->input('desktop'),
            'mobile' => $request->input('mobile'),
            'img' => $imgFileName ? 'uploads/ads/' . $imgFileName : null,
            'mobile_image' => $mobileImgFileName ? 'uploads/ads/' . $mobileImgFileName : null,
            'categories' => $categories,
            'url' => $request->input('url'),
            'start' => $request->input('start'),
            'end' => $request->input('end'),
            'status' => $request->input('status'),
            'ads_channel' => $ads_channel,
        ]);

        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('ads.index');


    }



    /**

     * Display the specified resource.

     */

    public function show(Home $home)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     */

    public function Edit($adsID,Request $request)

    {

        $ads=Ads::find($adsID);

        $categories=Category::orderBy('id','ASC')->get();


        return view('ads.edit')

        ->with('error', '0')
        ->with('categories', $categories)

        ->with('ads', $ads);

    }



    /**

     * Update the specified resource in storage.

     */

    public function Update($adsID,Request $request)

    {


          $categories=null;
        $ads_channel=null;
        if($request->has('reklam_alani')){
        $ads_channel = implode(',', $request->input('reklam_alani'));
        }
        if($request->has('categories')){
            $categories = implode(',', $request->input('categories'));
        }

        // Dosya yükleme yolu
        $destinationPath = public_path('/uploads/ads');

        // Hedef klasör yoksa oluştur
        if (!File::exists($destinationPath)) {
            File::makeDirectory($destinationPath, 0777, true, true);
        }

        // Resmi kaydet


        $selectedAds= Ads::find($adsID);
        $selectedAds->title=$request->input('title');
        $selectedAds->desktop=$request->input('desktop');
        $selectedAds->mobile=$request->input('mobile');
        $selectedAds->categories=$categories;
        $selectedAds->start=$request->input('start');
        $selectedAds->url=$request->input('url');
        $selectedAds->end=$request->input('end');
        $selectedAds->status=$request->input('status');
        $selectedAds->ads_channel=$ads_channel;

        if($request->has('img')){
        $imgFileName = $request->file('img')->getClientOriginalName();
        $request->file('img')->move($destinationPath, $imgFileName);
        $selectedAds->img='uploads/ads/' . $imgFileName;
        }
        if($request->has('mobile_img')){
        $mobileImgFileName = $request->file('mobile_img')->getClientOriginalName();
        $request->file('mobile_img')->move($destinationPath, $mobileImgFileName);
        $selectedAds->mobile_image='uploads/ads/' . $mobileImgFileName;
        }

        $selectedAds->save();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('ads.index');

    }



    /**

     * Remove the specified resource from storage.

     */

    public function Delete($adsID,Request $request)

    {

       $adsID= Ads::find($adsID);

       $adsID->delete();



        FlashNotification::message('İşleminiz başarıyla gerçekleşti')->success();

        return redirect()->route('ads.index');



    }

}

