<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use Auth;
use App\Models\DepositeUser;
use SoapClient;
use Carbon\Carbon;

class UserController extends BaseController
{
    public $successStatus = 200;


    public function GetUser(){
        $user = Auth::user();
        return $this->sendResponse($user);

    }

    public function VerificationTcNumber(Request $request){
        $tc_number=$request->tc_number;
        $date_of_birth=$request->date_of_birth;
        $name=$request->name;
        $surname=$request->surname;
        $dateexplode=explode('-',$date_of_birth);
        $user = Auth::user();
        $userControl=DepositeUser::where('tc_number',$tc_number)->where('tc_number_verified_at','!=',NULL)->count();
        if($userControl ==0){
            $client = new SoapClient("https://tckimlik.nvi.gov.tr/Service/KPSPublic.asmx?WSDL");
            try {
                $result = $client->TCKimlikNoDogrula([
                    'TCKimlikNo' => $tc_number,
                    'Ad' => $name,
                    'Soyad' => $surname,
                    'DogumYili' => $dateexplode[0]
                ]);
                if ($result->TCKimlikNoDogrulaResult) {
                    $updateUser=DepositeUser::where('id',$user->id)->update(['tc_number_verified_at'=>Carbon::now()]);
                    return $this->sendSuccess(' ','Kimlik Doğrulaması Başarılı');
                
            }else{
                    return $this->sendError(' ','Doğrulama Başarısız');
                }
            } catch (Exception $e) {
                echo $e;
                return $this->sendError(' ','Doğrulama Başarısız');
            }
        }else{
            return $this->sendError(' ','Kimlik Numarası Başka Bir Kullanıcı Tarafından Onaylanmıştır');
        }
        
    }

    //
}
