<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\News;
use App\Models\Video;
use App\Models\PhotoGallery;
use App\Models\Authors;
use App\Models\Exchange;
use App\Models\Setting;


class NewsController extends BaseController
{
    public $successStatus = 200;

    public function getMainHeadline(Request $request){
        $surmanset=News::where('is_mainheadline','1')->orderBy('mainheadline_order', 'asc')->orderBy('created_at', 'desc')->limit($request->limit ?? 5)->get();
        return $this->sendResponse($surmanset);
    }

    
    public function getFlashNews(Request $request){
            $flashhaberler = News::orderBy('created_at', 'desc')->limit(10)->get();
        $flashhaber = $flashhaberler->random();
        return $this->sendResponse($flashhaber);
    }

      public function getLastMinutes(Request $request){
      $sondakikahaberler=News::where('is_lastminute','1')->orderBy('id','desc')->limit($request->limit ?? 15)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($sondakikahaberler);
    }


    public function getHeadlineNews(Request $request){
         $mansethaberler=News::where('is_headline','1')->orderBy('headline_order', 'asc')->orderBy('created_at', 'desc')->limit($request->limit ?? 15)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($mansethaberler);
    }


    public function getCategoryNews(Request $request){
         $categoryNews=News::where('category_id',$request->category_id)->orderBy($request->orderKey ?? 'created_at', $request->orderValue ?? 'desc')->limit($request->limit ?? 15)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($categoryNews);
    }

        public function getAuthorsHabers(Request $request){
         $categoryNews=News::where('author_id',$request->author_id)->orderBy($request->orderKey ?? 'created_at', $request->orderValue ?? 'desc')->limit($request->limit ?? 15)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($categoryNews);
    }

        public function getSearchHabers(Request $request){
         $categoryNews=News::where('name','LIKE','%'.$request->author_id.'%')->orderBy($request->orderKey ?? 'created_at', $request->orderValue ?? 'desc')->limit($request->limit ?? 15)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($categoryNews);
    }




    public function getVideoGaleries(Request $request){
        $VideoNews=Video::orderBy('created_at', 'desc')->offset($request->offset ?? 0)->limit($request->limit ?? 15)->get();
        return $this->sendResponse($VideoNews);
    }


    public function getPhotoGaleries(Request $request){
        $PhotoGalleryNews=PhotoGallery::orderBy('created_at', 'desc')->offset($request->offset ?? 0)->limit($request->limit ?? 15)->get();
        return $this->sendResponse($PhotoGalleryNews);
    }

    public function getNews($id,Request $request){
        $news=News::where('id',$id)->with('category','author')->first();
        $newscount = $news->views_count ?? 0;
        $newsUpdate=News::where('id',$news->id)->update(['views_count'=>($newscount+1)]);
        return $this->sendResponse($news);
    }

     public function getPhotoGallery($id,Request $request){
       $PhotoGallery=PhotoGallery::where('id',$id)->with('images')->first();
        return $this->sendResponse($PhotoGallery);
    }

     public function getVideoGallery($id,Request $request){
        $video=Video::where('id',$id)->first();
        return $this->sendResponse($video);
    }

    public function getCategoryFromNewsPopular(Request $request){
        $news=News::where('id',$request->newsID)->first();
         $categoryNews=News::where('category_id',$news->category_id)->with('category','author')->orderBy('views_count', 'desc')->limit($request->limit ?? 5)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($categoryNews);
    }

    public function getCategoryFromNewsLast(Request $request){
         $news=News::where('id',$request->newsID)->first();
         $categoryNews=News::where('category_id',$news->category_id)->with('category','author')->orderBy('id', 'desc')->limit($request->limit ?? 15)->offset($request->offset ?? 0)->get();
        return $this->sendResponse($categoryNews);
    }


}
