<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use Auth;
use App\Models\DepositeUser;

class AuthController extends BaseController
{
    public $successStatus = 200;


    public function login(){
        if(Auth::attempt(['email' => request('email'), 'password' => request('password')])){
            $user = Auth::user();

            $client = \Laravel\Passport\Client::where('secret',request('client_secret'))->where('id',request('client_id'))->first();
            if ($client == NULL) {
                return response()->json(['error'=>'Unauthorised'], 401);
            }
            $success['access_token'] =  $user->createToken($client->name)->accessToken;
            $success['userID'] =  $user->id;
            $success['userNumber'] =  $user->user_number;
            $success['userName'] =  $user->name;
            $success['userSurname'] =  $user->surname;
            $success['userType'] =  (int)$user->user_type;
            return response()->json($success, $this->successStatus);
        }
        else{
            return response()->json(['error'=>'Unauthorised'], 401);
        }
    }

    public function register(Request $request){
        $name=$request->name;
        $surname=$request->surname;
        $mobilePhone=$request->mobile_phone;
        $email=$request->email;
        $password=$request->password;
        $userType=$request->userType;

        $userControl=DepositeUser::where('email',$email)->orWhere('mobile_phone',$mobilePhone)->count();
        if($userControl>0){
            return response()->json(['error'=>'Mail Adresi Ya Da Telefon Numarası Kullanılıyor'], 401);
        }else{
                    $LastUser=DepositeUser::orderBy('id','DESC')->first();
                    $newUser= new DepositeUser();
                    $newUser->name=$name;
                    $newUser->surname=$surname;
                    $newUser->email=$email;
                    $newUser->is_available=1;
                    $newUser->user_type=$userType;
                    $newUser->mobile_phone=$mobilePhone;
                    $newUser->password=bcrypt($password);
                    $newUser->user_number=($LastUser->user_number+1);
                    $newUser->save();
                    $success['userID'] =  $newUser->id;
                    $success['userNumber'] =  $LastUser->user_number+1;
                    return response()->json($success, $this->successStatus);
        }
    }

    //
}
