<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Models\Setting;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // Settings tablosundan 24 numaralı ID'ye sahip kaydı alıyoruz
        $getSettings = Setting::find(24);
        if ($getSettings) {
            $interval = $getSettings->value;

            // Eğer interval değeri varsa, cron ifadesini oluşturuyoruz
            if (is_numeric($interval) && $interval > 0) {
                $schedule->command('command:ihaajans')->cron("*/{$interval} * * * *");
            } else {
                \Log::error("Invalid interval value in settings: {$interval}");
            }
        } else {
            \Log::error("No setting found for ID 24");
        }

        // Her dakika çalıştırmak için
        $schedule->command('command:getStockExchange')->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
