<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\News;
use App\Models\AgencyBotCategory;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use App\Models\Setting;
use App\Models\Horoscope;
use Carbon\Carbon;

class GetHoroscope extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:Horoscope';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'İha AJans Haber Verilerini Burada Çekiyoruz';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }



    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $burclarlink=array('koc','boga','ikizler','yengec','aslan','basak','terazi','akrep','yay','oglak','kova','balik');
        $burclarTitle=array('Koç','Boğa','İkizler','Yengeç','Aslan','Başak','Terazi','Akrep','Yay','Oğlak','Kova','Balık');
        $i=0;
       foreach ($burclarlink as $link) {  
            $url = 'https://www.gunlukburc.net/gunluk-burc-yorumlari/'.$link.'.html';

            // HTML içeriğini al
            $html = $this->getHtmlContent($url);

            // Koç burcu günlük yorumunu al
            $start = '<h2 class="desc" itemprop="description">';
            $end = '<div><h3>'.$burclarTitle[$i].' Burcu Günlük Yıldız Falı</h3>';
            
            $horoscopeContent = $this->getBetween($html, $start, $end);

            // Reklamları ve linkleri temizle
            $horoscopeContent = $this->cleanContent($horoscopeContent);
            
            $horoscopeContent = str_replace('<div style="display:block; width:100%; min-width:300px; min-height:250px; height:auto !important; text-align: center;"><!-- gunlukburc-300x250 --></div>', '', $horoscopeContent);
            $horoscopeContent = str_replace('<div style="display:block; width: 100%; max-width: 336px; margin: auto;" id="mncbnr"></div>', '', $horoscopeContent);

            // Mevcut tarih
            $date = Carbon::now()->toDateString();

            // Aynı gün için aynı burç yorumu zaten var mı kontrol et
            $existingHoroscope = Horoscope::where('sign', $burclarTitle[$i])
                                          ->where('date', $date)
                                          ->first();

            if (!$existingHoroscope) {
                // Yeni burç yorumunu veritabanına ekle
                Horoscope::create([
                    'sign' => $burclarTitle[$i],
                    'content' => $horoscopeContent,
                    'date' => $date
                ]);
            }

            $i++;
        }

        return Command::SUCCESS;
    }

     private function getHtmlContent($url)
    {
        // cURL ile HTML içeriğini al
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

    private function getBetween($content, $start, $end)
    {
        $r = explode($start, $content);
        if (isset($r[1])) {
            $r = explode($end, $r[1]);
            return $r[0];
        }
        return '';
    }

       private function cleanContent($content)
    {
        // Google reklamlarını kaldır
        $content = preg_replace('/<ins[^>]*>.*?<\/ins>/', '', $content);
        $content = preg_replace('/<script[^>]*>.*?<\/script>/', '', $content);
        
        // Linkleri kaldır
        $content = preg_replace('/<a[^>]*>(.*?)<\/a>/', '$1', $content);
        $content = preg_replace('/<link[^>]*>/', '', $content);

        return $content;
    }
}
